#ifndef SCTDATA_IO_DEFECTLISTIS_H
#define SCTDATA_IO_DEFECTLISTIS_H

#include "Sct/Exception.h"
#include "Sct/Streamable.h"
#include "Sct/Streamer.h"
#include "../DefectIOHelper.h"

using namespace Sct;

namespace SctData {
namespace IO {

/**
This class is a Streamer for reading/writing DefectList
*/
class DefectListStreamer_v1 : public virtual Streamer {
public:
    //Streamer_v1 overrides
    virtual void write(OStream& out, const Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);
    virtual shared_ptr<Streamable> read(IStream& in, const IOManager& manager) const throw(LogicError, IoError);
    virtual void read(IStream& in, Streamable& ob, const IOManager& manager) const throw(LogicError, IoError);   
    virtual unsigned getVersion() const throw() {return s_version;}
 
private:
    DefectIOHelper helper;		///< The IOHelper
    DefectListStreamer_v1() throw();					///< Constructor is private
    static unsigned s_version;
    static bool inMap;					///< The static dummy variable for the ISManager map
};

}
}
#endif //#ifndef SCTDATA_IO_DEFECTLISTIS_H
