#include "DefectPrototype.h"
#include "Sct/LogicErrors.h"
#include <sstream>
#include <cstring>

using namespace std;
using namespace Sct;

namespace SctData {
    

map <int, DefectPrototype*>& DefectPrototype::getMap() {
    static map<int, DefectPrototype*> defectMap;
    return defectMap;
}
    
DefectPrototype::DefectPrototype(int id, DefectSeverity severity, string name, string d, double parameter) 
        :id(id), severity(severity), name(name), description(""), parameter(parameter) {
    if (getMap().find(id) != getMap().end()) {
	ostringstream oss;
	oss << "DefectPrototype already exists with id: " << id << " : " << getMap()[id]->getName();
	throw InvalidArgumentError(oss.str(), __FILE__, __LINE__);
    }   
    
    //Add to map
    getMap()[id] = this;

    char temp[100];
    sprintf(temp, d.c_str(), parameter);
    description = temp;
}

}
