#ifndef SCTDATA_DEFECTIOHELPER_H
#define SCTDATA_DEFECTIOHELPER_H

#include "DefectPrototype.h"
#include "Sct/LogicErrors.h"
#include "Sct/SctNames.h"
#include <sstream>

namespace SctData {
class DefectIOHelper {
public:	
    /**
      Gets the representation of a DefectPrototype
      @exceptions None
      */
    int getRepresentation(const DefectPrototype& defect) const;
    
    /**
      Gets the DefectPrototype corresponding to a representation
      @exceptions InvalidArgumentError if id does not correspond to a DefectPrototype
      */
    const DefectPrototype& getFromRep(int id) const;
};

//Inlines
inline int DefectIOHelper::getRepresentation(const DefectPrototype& defect) const {
	return defect.id;
}

inline const DefectPrototype& DefectIOHelper::getFromRep(int id) const {
    if (DefectPrototype::getMap().find(id)==DefectPrototype::getMap().end() ){
      // DIAGNOSTIC Message
      const std::map<int, DefectPrototype*>& theMap=DefectPrototype::getMap();
      std::ostringstream oss1;
      oss1 << "There are " << theMap.size() << " known DefectPrototypes:" << std::endl;
      for (std::map<int, DefectPrototype*>::const_iterator it = theMap.begin();
	   it!=theMap.end();
	   ++it){
	oss1 << (*it).first << " -> " << (*it).second->getName() << std::endl;
      }
      Sct::SctNames::Mrs() << "SCT_IO" << MRS_TEXT(oss1.str()) << MRS_DIAGNOSTIC << ENDM;
      // ERROR message
      std::ostringstream os; os<<"DefectIOHelper::getFromRep : no representation "<<id;
      throw Sct::InvalidArgumentError(os.str(), __FILE__, __LINE__);
    }
    return *DefectPrototype::getMap()[id];
}

}
#endif //#ifndef SCTDATA_DEFECTIOHELPER_H
