#ifndef SCTDATA_DEFECT_H
#define SCTDATA_DEFECT_H

#include "ModuleElement.h"

namespace SctData {
    
class DefectPrototype;

/**
  Represents a defect - basically a union of a ModuleElement and 
  a DefectPrototype.
  @author Matthew Palmer
  */
class Defect {
public:
    Defect(const DefectPrototype& proto, ModuleElement element) : prototype(&proto), element(element) {}

    /**
    Gets the module element affected by this defect.
    @note Nothrow
    */
    const ModuleElement& getModuleElement() const {return element;}

    /**
      Get the DefectPrototype
      @note Nothrow
      */
    const DefectPrototype& getPrototype() const {return *prototype;}
    
    /**
      Compares two defects returning true if they are the same
      @note Nothrow
      */
    bool operator==(const Defect& defect) const {return element==defect.element && *prototype==*defect.prototype;}

private:
    const DefectPrototype* prototype;		///< The prototype - pointer to allow assignment operator to work - points to static object so no need to delete
    ModuleElement element;			///< The element
};
}

#endif //SCTDATA_DEFECT_H
