#include "Defect_Test.h"
#include "../src/DefectList.h"
#include "../src/StandardDefects.h"
#include "../src/ModuleElement.h"
#include <boost/test/unit_test.hpp>

using boost::unit_test_framework::test_suite;
using namespace Sct;

namespace SctData{
  
    void testMerge(){
	DefectList mylist;
	mylist.addDefect( Defect(StandardDefects::DEAD, ModuleElement::Channel(10) ) );
	mylist.addDefect( Defect(StandardDefects::DEAD, ModuleElement::Channel(9) ) );
	mylist.addDefect( Defect(StandardDefects::DEAD, ModuleElement::Channel(11) ) );
	
	BOOST_CHECK_EQUAL( mylist.getAllDefects().size(), (unsigned) 1);
	BOOST_CHECK_EQUAL( ( *mylist.getAllDefects().begin() ).getModuleElement().getFirst(), 9);
	BOOST_CHECK_EQUAL( ( *mylist.getAllDefects().begin() ).getModuleElement().getLast(), 11);
	
	mylist.addDefect( Defect(StandardDefects::DEAD, ModuleElement::Chip(0) ) );
	BOOST_CHECK_EQUAL( mylist.getAllDefects().size(), (unsigned) 1);
	BOOST_CHECK_EQUAL( ( *mylist.getAllDefects().begin() ).getModuleElement().getFirst(), 0);
	BOOST_CHECK_EQUAL( ( *mylist.getAllDefects().begin() ).getModuleElement().getLast(), ModuleElement::Chip(0).getLast());
	
    }
  
  
  void testAffectingLogic() {
      DefectList mylist;
      mylist.addDefect( Defect(StandardDefects::DEAD, ModuleElement::Channel(10) ) );
      mylist.addDefect( Defect(StandardDefects::DEAD, ModuleElement::Channel(9) ) );
      mylist.addDefect( Defect(StandardDefects::DEAD, ModuleElement::Channel(11) ) );
      
      BOOST_CHECK_EQUAL(mylist.getDefectsAffectingElement(ModuleElement::Channel(10))->getAllDefects().size(), 1);
      BOOST_CHECK_EQUAL(mylist.defectSeverityAffectingElement(ModuleElement::Channel(10)), UNUSEABLE);
      
      BOOST_CHECK_EQUAL(mylist.getDefectsAffectingElement(ModuleElement::Chip(0))->getAllDefects().size(), 1);
      BOOST_CHECK_EQUAL(mylist.defectSeverityAffectingElement(ModuleElement::Chip(0)), UNUSEABLE);
      
      BOOST_CHECK_EQUAL(mylist.getDefectsAffectingElement(ModuleElement::Channel(12))->getAllDefects().size(), 0);
      BOOST_CHECK_EQUAL(mylist.defectSeverityAffectingElement(ModuleElement::Channel(12)), NONE);
      
      BOOST_CHECK_EQUAL(mylist.getDefectsAffectingElement(ModuleElement::Chip(1))->getAllDefects().size(), 0);
      BOOST_CHECK_EQUAL(mylist.defectSeverityAffectingElement(ModuleElement::Chip(1)), NONE);
  }
  
  void testEncompassingLogic() {
      DefectList mylist;
      mylist.addDefect( Defect(StandardDefects::DEAD, ModuleElement::Channel(10) ) );
      mylist.addDefect( Defect(StandardDefects::DEAD, ModuleElement::Channel(9) ) );
      mylist.addDefect( Defect(StandardDefects::DEAD, ModuleElement::Channel(11) ) );
      
      BOOST_CHECK_EQUAL(mylist.getDefectsEncompassingElement(ModuleElement::Channel(10))->getAllDefects().size(), 1);
      BOOST_CHECK_EQUAL(mylist.defectSeverityEncompassingElement(ModuleElement::Channel(10)), UNUSEABLE);
      
      BOOST_CHECK_EQUAL(mylist.getDefectsEncompassingElement(ModuleElement::Chip(0))->getAllDefects().size(), 0);
      BOOST_CHECK_EQUAL(mylist.defectSeverityEncompassingElement(ModuleElement::Chip(0)), NONE);
      
      BOOST_CHECK_EQUAL(mylist.getDefectsEncompassingElement(ModuleElement::Channel(12))->getAllDefects().size(), 0);
      BOOST_CHECK_EQUAL(mylist.defectSeverityEncompassingElement(ModuleElement::Channel(12)), NONE);
      
      BOOST_CHECK_EQUAL(mylist.getDefectsEncompassingElement(ModuleElement::Chip(1))->getAllDefects().size(), 0);
      BOOST_CHECK_EQUAL(mylist.defectSeverityEncompassingElement(ModuleElement::Chip(1)), NONE);
  }

  Defect_Test::Defect_Test() {
    add(BOOST_TEST_CASE(&testMerge));
    add(BOOST_TEST_CASE(&testAffectingLogic));
    add(BOOST_TEST_CASE(&testEncompassingLogic));
  }
}
