#include "ScanResultWriter.h"
#include "dataTypes.h"
#include "Sct/Exception.h"

#include <CommonWithDsp/processor.h>
#include <CommonWithDsp/sctStructure.h>
#include <CommonWithDsp/ABCD/ABCDscans.h>

#include <cstdio>
#include <cstring>

using namespace std;
using namespace SctData;

//Prototypes
void handleFile(const char* name, int i);

//We assume we are given a list of files containing binary slice data
//Then we fake a header.
int main(int argc, char** argv) {
    Sct::setExceptionHandlers(argv[0]);
    for (int i=1; i<argc; ++i) {	
	handleFile(argv[i], i);	
    }
    return 0;
}
	
//Handle the file
//Alogorithm is discover file size, allocate RAM
//Use the structs to fake the data then publish!
void handleFile(const char* name, int i) {
    try {
	FILE * pFile;
	long lSize;
	
	pFile = fopen (name, "rb" );
	if (pFile==NULL) throw FileException(name, "File Not Found", __FILE__, __LINE__);

	// obtain file size.
	fseek (pFile , 0 , SEEK_END);
	lSize = ftell (pFile);
	rewind (pFile);

	//New way of reading
	scan_result_ptrs scanResult;
	
	//read in header
	int n = fread(&scanResult.header, sizeof(ScanHeader), 1, pFile);
	
	//scanResult.header.scanNumber = i;
	
	//Read in scan points
	scanResult.points = new FLOAT32[scanResult.header.npoints];
	scanResult.nEvents = new UINT32[scanResult.header.npoints];
	scanResult.nErrorEvents = new UINT32[scanResult.header.npoints];
	
	fseek(pFile, scanResult.header.pntPoints, SEEK_SET);
	n = fread(scanResult.points, sizeof(FLOAT32), scanResult.header.npoints, pFile);
	if (n != scanResult.header.npoints) { 
	    ostringstream oss;
	    oss << "Failed to read in ScanPoints.  Expected: " << scanResult.header.npoints << " Read: " << n;
	    throw StreamCorruptedException(oss.str(), __FILE__, __LINE__);
	}
	
	fseek(pFile, scanResult.header.pntEvents, SEEK_SET);
	n = fread(scanResult.nEvents, sizeof(UINT32), scanResult.header.npoints, pFile);
	if (n != scanResult.header.npoints) { 
	    ostringstream oss;
	    oss << "Failed to read in ScanPoints, nEvents.  Expected: " << scanResult.header.npoints << " Read: " << n;
	    throw StreamCorruptedException(oss.str(), __FILE__, __LINE__);
	}
	
	fseek(pFile, scanResult.header.pntErrors, SEEK_SET);
	n = fread(scanResult.nErrorEvents, sizeof(UINT32), scanResult.header.npoints, pFile);
	if (n != scanResult.header.npoints) { 
	    ostringstream oss;
	    oss << "Failed to read in ScanPoints, nErrorEvents.  Expected: " << scanResult.header.npoints << " Read: " << n;
	    throw StreamCorruptedException(oss.str(), __FILE__, __LINE__);
	}
	
	
	//Read in data
	scanResult.data = new short[scanResult.header.size];
	//cout << scanResult.header.size << endl;
	fseek(pFile, scanResult.header.pntData, SEEK_SET);
	n = fread(scanResult.data, sizeof(UINT16), scanResult.header.size, pFile);
	if (n != scanResult.header.size) { 
	    ostringstream oss;
	    oss << "Failed to read in data.  Expected: " << scanResult.header.size << " Read: " << n;
	    throw StreamCorruptedException(oss.str(), __FILE__, __LINE__);
	}
	
	//All done
	fclose (pFile);
	
	ScanResultWriter::publish(scanResult);

	//We leak here if something bad happens, I know, but this isn't meant to be a big or long program!
	delete [] scanResult.points;
	delete [] scanResult.nEvents;
	delete [] scanResult.nErrorEvents;
	delete [] (short*)scanResult.data;	
    } catch (Sct::Throwable& t) {
	t.sendToMrs(MRS_ERROR);
    }
}
