/*
 * ResultHeaderTest.java
 *
 * Created on 15 September 2003, 17:03
 */

package SctData;

import junit.framework.*;
import Sct.*;
import Sct.TestFramework.*;

/**
 * Tests for the ResultHeader class
 * @author  Matthew Palmer
 */
public class ResultHeaderTest extends StreamableTestCase {
    
    public void testEquality() {
        ResultHeader h1 = new ResultHeader(1000, 50, "MyModule", new NullVariable(), "20010101T120035", "20010101T130035");
        ResultHeader h2 = new ResultHeader(1000, 50, "MyModule", new NullVariable(), "20010101T120035", "20010101T130035");
        assertEquals(h1, h2);
        ResultHeader h3 = new ResultHeader(1000, 50, "MyModule1", new NullVariable(), "20010101T120035", "20010101T130035");
        assertFalse(h1.equals(h3));
        ResultHeader h4 = new ResultHeader(1000, 51, "MyModule", new NullVariable(), "20010101T120035", "20010101T130035");
        assertFalse(h1.equals(h4));
        ResultHeader h5 = new ResultHeader(1010, 50, "MyModule", new NullVariable(), "20010101T120035", "20010101T130035");
        assertFalse(h1.equals(h5));
	ResultHeader h6 = new ResultHeader(1010, 50, "MyModule", new NullVariable(), "20010101T120035", "20010101T140035");
        assertFalse(h1.equals(h6));
	ResultHeader h7 = new ResultHeader(1010, 50, "MyModule", new NullVariable(), "20010101T130035", "20010101T130035");
        assertFalse(h1.equals(h7));
    }
    
    public void testUniqueID() {
        ResultHeader h1 = new ResultHeader(1000, 50, "MyModule", new NullVariable(), "20010101T130035", "20010101T130035");
        assertEquals(h1.getUniqueID(), "1000.50.MyModule");
    }
    
    public Streamable getStreamable() {
        return new ResultHeader(2000, 50, "MyModule", new NullVariable(), "20010101T120035", "20010101T130035");
    }    
    
    protected boolean compare(Object s1, Object s2) {
        return s1.equals(s2);
    }    
    
}
