#include "XmlStyleStream.h"

namespace Sct{

XmlStyleOStream::XmlStyleOStream(std::ostream& out) : m_out(out) {}

XmlStyleOStream::~XmlStyleOStream(){}


static std::string escape[] = { "&amp;", "&apos;", "&quot;", "&gt", "&lt;" };
static std::string entity[] = { "&" , "'", "\"", ">", "<" };

static std::string invalidate( const char * val, int length )
{
	std::string text( val, length );
	for ( int i = 0; i < 5; i++ )
	{
		std::string::size_type pos = 0;
		while( ( pos = text.find( escape[i] ) ) != std::string::npos )
		{
			text.replace( pos, escape[i].length(), entity[i] );
		}
	}
	return text;
}

static std::string validate( const char * val, int length )
{
	std::string text( val, length );
	for ( int i = 0; i < 5; i++ )
	{
		std::string::size_type pos = 0;
		while( ( pos = text.find( entity[i], pos ) ) != std::string::npos )
		{
			text.replace( pos++, entity[i].length(), escape[i] );
		}
	}
	return text;
}

XmlStyleOStream& XmlStyleOStream::operator<< ( bool v )
{
	m_out << "<a t=\"bool\">" << v << "</a>" << std::endl;
	return *this;
}

XmlStyleOStream& XmlStyleOStream::operator<< ( char v )
{
	m_out << "<a t=\"s8\">" << static_cast<short>( v ) << "</a>" << std::endl;
	return *this;
}

XmlStyleOStream& XmlStyleOStream::operator<< ( unsigned char v )
{
	m_out << "<a t=\"u8\">" << static_cast<short>( static_cast<char>( v ) ) << "</a>" << std::endl;
	return *this;
}

XmlStyleOStream& XmlStyleOStream::operator<< ( short v )
{
	m_out << "<a t=\"s16\">" << v << "</a>" << std::endl;
	return *this;
}

XmlStyleOStream& XmlStyleOStream::operator<< ( unsigned short v )
{
	m_out << "<a t=\"u16\">" << static_cast<short>( v ) << "</a>" << std::endl;
	return *this;
}

XmlStyleOStream& XmlStyleOStream::operator<< ( int v )
{
	m_out << "<a t=\"s32\">" << v << "</a>" << std::endl;
	return *this;
}

XmlStyleOStream& XmlStyleOStream::operator<< ( unsigned int v )
{
	m_out << "<a t=\"u32\">" << static_cast<int>( v ) << "</a>" << std::endl;
	return *this;
}

XmlStyleOStream& XmlStyleOStream::operator<< ( long v )
{
	m_out << "<a t=\"s32\">" << v << "</a>" << std::endl;
	return *this;
}

XmlStyleOStream& XmlStyleOStream::operator<< ( unsigned long v )
{
	m_out << "<a t=\"u32\">" << static_cast<long>( v ) << "</a>" << std::endl;
	return *this;
}

XmlStyleOStream& XmlStyleOStream::operator<< ( float v )
{
	m_out << "<a t=\"float\">" << v << "</a>" << std::endl;
	return *this;
}

XmlStyleOStream& XmlStyleOStream::operator<< ( double v )
{
	m_out << "<a t=\"double\">" << v << "</a>" << std::endl;
	return *this;
}

XmlStyleOStream& XmlStyleOStream::operator<< ( const char * v )
{
	const char * val = ( v == 0 ? "" : v );
	m_out << "<a t=\"string\">" << validate( val, strlen( val ) ) << "</a>" << std::endl;
	return *this;
}

XmlStyleOStream& XmlStyleOStream::operator<< ( const unsigned char * v )
{
	return ( (*this) << reinterpret_cast<const char *>(v) );
}

XmlStyleOStream& XmlStyleOStream::operator<< ( const std::string & v )
{
	return ( (*this) << v.c_str() );
}


//--------------------------------------------------------
// Class XmlStyleOStream public methods
//--------------------------------------------------------

XmlStyleOStream& XmlStyleOStream::put( const bool * p, size_t size )
{
	m_out << "<a t=\"bool\" s=\"" << size << "\">";
	for ( size_t i = 0; i < size; i++ )
	{
		m_out << p[i] << " ";
	}
	m_out << "</a>" << std::endl;
	return *this;
}

XmlStyleOStream& XmlStyleOStream::put( const char * p, size_t size )
{
	m_out << "<a t=\"s8\" s=\"" << size << "\">";
	for ( size_t i = 0; i < size; i++ )
	{
		m_out << static_cast<const short>( p[i] ) << " ";
	}
	m_out << "</a>" << std::endl;
	return *this;
}

XmlStyleOStream& XmlStyleOStream::put( const unsigned char * p, size_t size )
{
	m_out << "<a t=\"u8\" s=\"" << size << "\">";
	for ( size_t i = 0; i < size; i++ )
	{
		m_out << static_cast<const short>( static_cast<const char>( p[i] ) ) << " ";
	}
	m_out << "</a>" << std::endl;
	return *this;
}

XmlStyleOStream& XmlStyleOStream::put( const short * p, size_t size )
{
	m_out << "<a t=\"s16\" s=\"" << size << "\">";
	for ( size_t i = 0; i < size; i++ )
	{
		m_out << p[i] << " ";
	}
	m_out << "</a>" << std::endl;
	return *this;
}

XmlStyleOStream& XmlStyleOStream::put( const unsigned short	* p, size_t size )
{
	m_out << "<a t=\"u16\" s=\"" << size << "\">";
	for ( size_t i = 0; i < size; i++ )
	{
		m_out << static_cast<const short>( p[i] ) << " ";
	}
	m_out << "</a>" << std::endl;
	return *this;
}

XmlStyleOStream& XmlStyleOStream::put( const int * p, size_t size )
{
	m_out << "<a t=\"s32\" s=\"" << size << "\">";
	for ( size_t i = 0; i < size; i++ )
	{
		m_out << p[i] << " ";
	}
	m_out << "</a>" << std::endl;
	return *this;
}

XmlStyleOStream& XmlStyleOStream::put( const unsigned int * p, size_t size )
{
	m_out << "<a t=\"u32\" s=\"" << size << "\">";
	for ( size_t i = 0; i < size; i++ )
	{
		m_out << static_cast<const int>( p[i] ) << " ";
	}
	m_out << "</a>" << std::endl;
	return *this;
}

XmlStyleOStream& XmlStyleOStream::put( const long * p, size_t size )
{
	m_out << "<a t=\"s32\" s=\"" << size << "\">";
	for ( size_t i = 0; i < size; i++ )
	{
		m_out << p[i] << " ";
	}
	m_out << "</a>" << std::endl;
	return *this;
}

XmlStyleOStream& XmlStyleOStream::put( const unsigned long * p, size_t size )
{
	m_out << "<a t=\"u32\" s=\"" << size << "\">";
	for ( size_t i = 0; i < size; i++ )
	{
		m_out << static_cast<const long>( p[i] ) << " ";
	}
	m_out << "</a>" << std::endl;
	return *this;
}

XmlStyleOStream& XmlStyleOStream::put( const float * p, size_t size )
{
	m_out << "<a t=\"float\" s=\"" << size << "\">";
	for ( size_t i = 0; i < size; i++ )
	{
		m_out << p[i] << " ";
	}
	m_out << "</a>" << std::endl;
	return *this;
}

XmlStyleOStream& XmlStyleOStream::put( const double * p, size_t size )
{
	m_out << "<a t=\"double\" s=\"" << size << "\">";
	for ( size_t i = 0; i < size; i++ )
	{
		m_out << p[i] << " ";
	}
	m_out << "</a>" << std::endl;
	return *this;
}

XmlStyleOStream& XmlStyleOStream::put( const std::string * p, size_t size )
{
	m_out << "<a t=\"string\" s=\"" << size << "\">";
	for ( size_t i = 0; i < size; i++ )
	{
		m_out << "\"" << validate( p[i].c_str(), p[i].length() ) << "\" ";
	}
	m_out  << "</a>" << std::endl;
	return *this;
}

//--------------------------------------------------------
// Class XmlStyleIStream public constructors and operators
//--------------------------------------------------------

XmlStyleIStream::~XmlStyleIStream(){}


XmlStyleIStream::XmlStyleIStream(std::istream& is)
  :  count_( 0 ),
     entries_ ( 0 )
{
  std::ostringstream os;
  std::string tmp;
  while (is.good()){
    is >> tmp;
    os << tmp+" ";
  }

  data_=os.str();

	std::string::size_type	pos = 0;
	while ( ( pos = data_.find("<a t=", pos) ) != std::string::npos )
	{
		pos++;
		entries_++;
	}
	entries_--;
}

XmlStyleIStream& XmlStyleIStream::operator>>( char * v )
{
	std::string::size_type	start;
	
	start  = data_.find("<a t=", count_);
	start  = data_.find(">", start);
	start++;
	count_ = data_.find("</a>", start);
	
	std::string str = invalidate( data_.data() + start, count_ - start );
	strcpy( v, str.c_str() );

	return *this;
}

XmlStyleIStream& XmlStyleIStream::operator>>( unsigned char * v )
{
	return ( *this >> reinterpret_cast<char*>( v ));
}

XmlStyleIStream& XmlStyleIStream::operator>>( char ** v )
{
	std::string::size_type	start;
	
	start  = data_.find("<a t=", count_);
	start  = data_.find(">", start);
	start++;
	count_ = data_.find("</a>", start);
	
	std::string str = invalidate( data_.data() + start, count_ - start );
	(*v) = new char[str.length() + 1];
	strcpy( (*v), str.c_str() );
	
	return *this;
}

XmlStyleIStream& XmlStyleIStream::operator>>( unsigned char ** v )
{
	return ( *this >> reinterpret_cast<char**>( v ) );
}

XmlStyleIStream& XmlStyleIStream::operator>>(bool& v)
{
	std::string::size_type	start;
	
	start  = data_.find("<a t=", count_);
	start  = data_.find(">", start);
	start++;
	count_ = data_.find("</a>", start);
	
	std::istringstream sin( data_.substr( start, count_ - start ) );
	sin >> v;

	return *this;
}

XmlStyleIStream& XmlStyleIStream::operator>>(char& v)
{
	std::string::size_type	start;
	
	start  = data_.find("<a t=", count_);
	start  = data_.find(">", start);
	start++;
	count_ = data_.find("</a>", start);
	
	std::istringstream sin( data_.substr( start, count_ - start ) );
	short s;
	sin >> s;
	v = s;

	return *this;
}

XmlStyleIStream& XmlStyleIStream::operator>>(unsigned char& v)
{
	std::string::size_type	start;
	
	start  = data_.find("<a t=", count_);
	start  = data_.find(">", start);
	start++;
	count_ = data_.find("</a>", start);
	
	std::istringstream sin( data_.substr( start, count_ - start ) );
	unsigned short s;
	sin >> s;
	v = s;
		
	return *this;
}

XmlStyleIStream& XmlStyleIStream::operator>>(int& v)
{
	std::string::size_type	start;
	
	start  = data_.find("<a t=", count_);
	start  = data_.find(">", start);
	start++;
	count_ = data_.find("</a>", start);
	
	std::istringstream sin( data_.substr( start, count_ - start ) );
	sin >> v;
	return *this;
}

XmlStyleIStream& XmlStyleIStream::operator>>(long& v)
{
	std::string::size_type	start;
	
	start  = data_.find("<a t=", count_);
	start  = data_.find(">", start);
	start++;
	count_ = data_.find("</a>", start);
	
	std::istringstream sin( data_.substr( start, count_ - start ) );
	sin >> v;

	return *this;
}

XmlStyleIStream& XmlStyleIStream::operator>>(short& v)
{
	std::string::size_type	start;
	
	start  = data_.find("<a t=", count_);
	start  = data_.find(">", start);
	start++;
	count_ = data_.find("</a>", start);
	
	std::istringstream sin( data_.substr( start, count_ - start ) );
	sin >> v;

	return *this;
}

XmlStyleIStream& XmlStyleIStream::operator>>(unsigned int& v)
{
	std::string::size_type	start;
	
	start  = data_.find("<a t=", count_);
	start  = data_.find(">", start);
	start++;
	count_ = data_.find("</a>", start);
	
	std::istringstream sin( data_.substr( start, count_ - start ) );
	sin >> v;

	return *this;
}

XmlStyleIStream& XmlStyleIStream::operator>>(unsigned long& v)
{
	std::string::size_type	start;
	
	start  = data_.find("<a t=", count_);
	start  = data_.find(">", start);
	start++;
	count_ = data_.find("</a>", start);
	
	std::istringstream sin( data_.substr( start, count_ - start ) );
	sin >> v;

	return *this;
}

XmlStyleIStream& XmlStyleIStream::operator>>(unsigned short& v)
{
	std::string::size_type	start;
	
	start  = data_.find("<a t=", count_);
	start  = data_.find(">", start);
	start++;
	count_ = data_.find("</a>", start);
	
	std::istringstream sin( data_.substr( start, count_ - start ) );
	sin >> v;

	return *this;
}

XmlStyleIStream& XmlStyleIStream::operator>>(float& v)
{
	std::string::size_type	start;
	
	start  = data_.find("<a t=", count_);
	start  = data_.find(">", start);
	start++;
	count_ = data_.find("</a>", start);
	
	std::istringstream sin( data_.substr( start, count_ - start ) );
	sin >> v;

	return *this;
}

XmlStyleIStream& XmlStyleIStream::operator>>(double& v)
{
	std::string::size_type	start;
	
	start  = data_.find("<a t=", count_);
	start  = data_.find(">", start);
	start++;
	count_ = data_.find("</a>", start);
	
	std::istringstream sin( data_.substr( start, count_ - start ) );
	sin >> v;

	return *this;
}

XmlStyleIStream& XmlStyleIStream::operator>>(std::string & v)
{
	char * str;
	(*this) >> &str;
	v = str;
	delete[] str;
	return *this;
}

//---------------------------------------------------------
// XmlStyleIStream private method
//---------------------------------------------------------

void XmlStyleIStream::reset( )
{
	count_ = 0;
}

size_t XmlStyleIStream::entries( ) const
{
	return entries_;
}

size_t XmlStyleIStream::readSize( ) const
{
	std::string::size_type	start, end;
	
	start  = data_.find("<a t=", count_);
	end    = data_.find(">", start);
	start  = data_.find(" s=\"", start);
	if ( start == std::string::npos || start > end )
	{
		return 1;
	}
	start += 4;
	end = data_.find("\"", start);
	
	std::istringstream sin( data_.substr( start, end - start ) );
	
	size_t size;
	sin >> size;
	return size;
}

bool XmlStyleIStream::isArray( ) const
{
	std::string::size_type	start, end;
	
	start  = data_.find("<a t=", count_);
	end    = data_.find(">", start);
	start  = data_.find(" s=\"", start);
	if ( start == std::string::npos || start > end )
	{
		return false;
	}
	else
	{
		return true;
	}
}

//---------------------------------------------------------
// XmlStyleIStream public methods 
//---------------------------------------------------------


XmlStyleIStream& XmlStyleIStream::get( bool ** v, size_t & size )
{
	size = readSize();
	
	std::string::size_type	start;
	
	start  = data_.find("\">", count_) + 2;
	count_ = data_.find("</a>", start);
	
	std::istringstream sin( data_.substr( start, count_ - start ) );
	*v = new bool[size];
	for ( size_t i = 0; i < size; i++ )
	{
		sin >> (*v)[i];
	}

	return *this;
}

XmlStyleIStream& XmlStyleIStream::get( char ** v, size_t & size )
{
	size = readSize();
	
	std::string::size_type	start;
	
	start  = data_.find("\">", count_) + 2;
	count_ = data_.find("</a>", start);
	
	std::istringstream sin( data_.substr( start, count_ - start ) );
	*v = new char[size];
	for ( size_t i = 0; i < size; i++ )
	{
		short s;
		sin >> s;
		(*v)[i] = static_cast<char>( s );
	}

	return *this;
}

XmlStyleIStream& XmlStyleIStream::get( unsigned char ** v, size_t & size )
{
	size = readSize();
	
	std::string::size_type	start;
	
	start  = data_.find("\">", count_) + 2;
	count_ = data_.find("</a>", start);
	
	std::istringstream sin( data_.substr( start, count_ - start ) );
	*v = new unsigned char[size];
	for ( size_t i = 0; i < size; i++ )
	{
		short s;
		sin >> s;
		(*v)[i] = static_cast<unsigned char>( s );
	}
	return *this;
}

XmlStyleIStream& XmlStyleIStream::get( short ** v, size_t & size )
{
	size = readSize();
	
	std::string::size_type	start;
	
	start  = data_.find("\">", count_) + 2;
	count_ = data_.find("</a>", start);
	
	std::istringstream sin( data_.substr( start, count_ - start ) );
	*v = new short[size];
	for ( size_t i = 0; i < size; i++ )
	{
		sin >> (*v)[i];
	}
	return *this;
}
XmlStyleIStream& XmlStyleIStream::get( unsigned short ** v, size_t & size )
{
	size = readSize();
	
	std::string::size_type	start;
	
	start  = data_.find("\">", count_) + 2;
	count_ = data_.find("</a>", start);
	
	std::istringstream sin( data_.substr( start, count_ - start ) );
	*v = new unsigned short[size];
	for ( size_t i = 0; i < size; i++ )
	{
		sin >> (*v)[i];
	}
	return *this;
}
XmlStyleIStream& XmlStyleIStream::get( int ** v, size_t & size )
{
	size = readSize();
	
	std::string::size_type	start;
	
	start  = data_.find("\">", count_) + 2;
	count_ = data_.find("</a>", start);
	
	std::istringstream sin( data_.substr( start, count_ - start ) );
	*v = new int[size];
	for ( size_t i = 0; i < size; i++ )
	{
		sin >> (*v)[i];
	}
	return *this;
}
XmlStyleIStream& XmlStyleIStream::get( unsigned int ** v, size_t & size )
{
	size = readSize();
	
	std::string::size_type	start;
	
	start  = data_.find("\">", count_) + 2;
	count_ = data_.find("</a>", start);
	
	std::istringstream sin( data_.substr( start, count_ - start ) );
	*v = new unsigned int[size];
	for ( size_t i = 0; i < size; i++ )
	{
		sin >> (*v)[i];
	}
	return *this;
}
XmlStyleIStream& XmlStyleIStream::get( long ** v, size_t & size )
{
	size = readSize();
	
	std::string::size_type	start;
	
	start  = data_.find("\">", count_) + 2;
	count_ = data_.find("</a>", start);
	
	std::istringstream sin( data_.substr( start, count_ - start ) );
	*v = new long[size];
	for ( size_t i = 0; i < size; i++ )
	{
		sin >> (*v)[i];
	}
	return *this;
}
XmlStyleIStream& XmlStyleIStream::get( unsigned long ** v, size_t & size )
{
	size = readSize();
	
	std::string::size_type	start;
	
	start  = data_.find("\">", count_) + 2;
	count_ = data_.find("</a>", start);
	
	std::istringstream sin( data_.substr( start, count_ - start ) );
	*v = new unsigned long[size];
	for ( size_t i = 0; i < size; i++ )
	{
		sin >> (*v)[i];
	}
	return *this;
}
XmlStyleIStream& XmlStyleIStream::get( float ** v, size_t & size )
{
	size = readSize();
	
	std::string::size_type	start;
	
	start  = data_.find("\">", count_) + 2;
	count_ = data_.find("</a>", start);
	
	std::istringstream sin( data_.substr( start, count_ - start ) );
	*v = new float[size];
	for ( size_t i = 0; i < size; i++ )
	{
		sin >> (*v)[i];
	}
	return *this;
}
XmlStyleIStream& XmlStyleIStream::get( double ** v, size_t & size )
{
	size = readSize();
	
	std::string::size_type	start;
	
	start  = data_.find("\">", count_) + 2;
	count_ = data_.find("</a>", start);
	
	std::istringstream sin( data_.substr( start, count_ - start ) );
	*v = new double[size];
	for ( size_t i = 0; i < size; i++ )
	{
		sin >> (*v)[i];
	}
	return *this;
}

XmlStyleIStream& XmlStyleIStream::get( std::string ** v, size_t & size )
{
	size = readSize();
	
	std::string::size_type	start, end;
	
	start  = data_.find("\">", count_) + 2;
	count_ = data_.find("</a>", start);
	
	*v = new std::string[size];
	for ( size_t i = 0; i < size; i++ )
	{
		start  = data_.find("\"", start) + 1;
		end  = data_.find("\"", start);
		(*v)[i] = invalidate( data_.c_str() + start, end - start );
		start = end + 2;
	}
	return *this;
}

//-----------------------------------------------------------
// Read to the static arrays - does not allocate memory
//-----------------------------------------------------------


XmlStyleIStream& XmlStyleIStream::get( bool * const v, const size_t size )
{
	size_t	n;
	bool *	buff;
	
	get( &buff, n );
	size_t	min = ( n < size ? n : size );
	memcpy( v, buff, min * sizeof(bool) );
	delete[] buff;

	return *this;
}

XmlStyleIStream& XmlStyleIStream::get( char * const v, const size_t size )
{
	size_t	n;
	char *	buff;
	
	get( &buff, n );
	size_t	min = ( n < size ? n : size );
	memcpy( v, buff, min * sizeof(char) );
	delete[] buff;

	return *this;
}

XmlStyleIStream& XmlStyleIStream::get(unsigned char * const v, const size_t size )
{
	size_t	n;
	unsigned char *	buff;
	
	get( &buff, n );
	size_t	min = ( n < size ? n : size );
	memcpy( v, buff, min * sizeof(unsigned char) );
	delete[] buff;

	return *this;
}

XmlStyleIStream& XmlStyleIStream::get( short * const v, const size_t size )
{
	size_t	n;
	short *	buff;
	
	get( &buff, n );
	size_t	min = ( n < size ? n : size );
	memcpy( v, buff, min * sizeof(short) );
	delete[] buff;

	return *this;
}
XmlStyleIStream& XmlStyleIStream::get( unsigned short * const v, const size_t size )
{
	size_t			n;
	unsigned short *	buff;
	
	get( &buff, n );
	size_t	min = ( n < size ? n : size );
	memcpy( v, buff, min * sizeof(unsigned short) );
	delete[] buff;

	return *this;
}

XmlStyleIStream& XmlStyleIStream::get( int * const v, const size_t size )
{
	size_t	n;
	int *	buff;
	
	get( &buff, n );
	size_t	min = ( n < size ? n : size );
	memcpy( v, buff, min * sizeof(int) );
	delete[] buff;

	return *this;
}

XmlStyleIStream& XmlStyleIStream::get( unsigned int * const v, const size_t size )
{
	size_t	n;
	unsigned int *	buff;
	
	get( &buff, n );
	size_t	min = ( n < size ? n : size );
	memcpy( v, buff, min * sizeof(unsigned int) );
	delete[] buff;

	return *this;
}

XmlStyleIStream& XmlStyleIStream::get( long * const v, const size_t size )
{
	size_t	n;
	long *	buff;
	
	get( &buff, n );
	size_t	min = ( n < size ? n : size );
	memcpy( v, buff, min * sizeof(long) );
	delete[] buff;

	return *this;
}

XmlStyleIStream& XmlStyleIStream::get( unsigned long * const v, const size_t size )
{
	size_t	n;
	unsigned long *	buff;
	
	get( &buff, n );
	size_t	min = ( n < size ? n : size );
	memcpy( v, buff, min * sizeof(unsigned long) );
	delete[] buff;

	return *this;
}

XmlStyleIStream& XmlStyleIStream::get( float * const v, const size_t size )
{
	size_t	n;
	float *	buff;
	
	get( &buff, n );
	size_t	min = ( n < size ? n : size );
	memcpy( v, buff, min * sizeof(float) );
	delete[] buff;

	return *this;
}

XmlStyleIStream& XmlStyleIStream::get( double * const v, const size_t size )
{
	size_t	n;
	double *	buff;
	
	get( &buff, n );
	size_t	min = ( n < size ? n : size );
	memcpy( v, buff, min * sizeof(double) );
	delete[] buff;

	return *this;
}

XmlStyleIStream& XmlStyleIStream::get( std::string * const v, const size_t size )
{
	size_t	n;
	std::string * buff;
	get( &buff, n );
	
	size_t	min = ( n < size ? n : size );
	
	for( size_t i = 0; i < min; i++ )
	{
		v[i] = buff[i];
	}
	
	delete[] buff;
	return *this;
}

}
