#ifndef SCTNAMES_H
#define SCTNAMES_H

#include <is/isinfo.h>
#include <string>

class MRSStream;

namespace Sct {

/**
This static class exists to provide the names of SCT Online Software components.
For example, the partition name, the name of the IS server that event data is stored in.
It also provides a few simple utility functions.  For instance, it caches a reference to the Partition.
<p>
Also, at some point, it may be useful to expand this class if we wanted to run say a subset of modules
entirely independantly of the rest and thus wanted to have all those components in a separate partition.
(This is why all access is via methods rather than static member variables.)
*/
class SctNames {
public:
    /**
    Get the Partition name.
    */
    static std::string getPartitionName() throw();

    /**
    Get the IS server name for raw event data.
    */
    static std::string  getEventDataName() throw();

    /**
    Get the IS server name for fitted data.
    */
    static std::string  getFittedDataName() throw();

    /**
    Get the IS server name for fitted data.
    */
    static std::string  getTestDataName() throw();

    /**
    Get the IS server name for fitted data.
    */
    static std::string getControlDataName() throw();

     /**
       *     Get the IS server name for fitted data.
       */
    static std::string getRetrievedDataName() throw();

    
    /**
      Get the directory for storing temporary files
      */
    static std::string getTempDir() throw();

    /**
    Get the location.
    */
    static std::string getLocation() throw();

    /**
    Get the user.
    */
    static std::string getUser() throw();

    /**
    Get the IPC Partition
    */
    static IPCPartition& getPartition() throw();

    /**
    Get the IS dictionary.
    */
    static ISInfoDictionary& getISDictionary() throw();

    /**
     * Gets the directory for storing all persistent data in     
     */
    static std::string getPersistentDir() throw();
    
    /**
      Gets the directory for storing log files in
      */
    static std::string getLogDir() throw();
    
    static MRSStream& Mrs();
};
}

#endif //#ifndef SCTNAMES_H
