#ifndef SCT_MATHSERROR_H
#define SCT_MATHSERROR_H

namespace Sct {

/**
 * Thrown when an mathametical error has occured
 * e.g. divide by zero
 * @author Alan Barr and anglicized by Matthew Palmer
 * @ingroup Exceptions
 */
class MathsError : public Error {
public:
    /**
      Creates an Exception with message msg and no cause
      */
    MathsError(const string& msg, const string& file, int line) throw() {
	initialize("MATHS_ERROR", "Sct::MathsError", msg, 0, file, line);
    }
    
    /**
      Creates an Exception with a cause.  Useful for simply wrapping
      exceptions.
      */
    MathsError(Throwable& cause, const string& file, int line) throw() {
	initialize("MATHS_ERROR", "Sct::MathsError", "", &cause, file, line);
    }
    
    /**
      Creates an Exception with a message and a cause
      */
    MathsError(const string& msg, Throwable& cause, const string& file, int line) throw() {
	initialize("MATHS_ERROR", "Sct::MathsError", msg, &cause, file, line);
    }
    
protected:
    MathsError() throw() {}       
};
}
#endif //SCT_MATHSERROR_H
