#ifndef SCT_ISISTREAMWRAPPER_H
#define SCT_ISISTREAMWRAPPER_H
//#include "isstream_bugfix.h"
#include "is/isstream.h"
#include "IStream.h"

//#ifndef IS_STREAM_BUGFIX_H
//#error You have included is/isstream.h, but I need the bugfix version (isstream_bugfix.h) with virtual methods for the ISistream
//#endif

namespace Sct{
  /** Wrapper to wrap a ISistream as a Sct::IStream */
  class ISIStreamWrapper : public virtual ISistream {
  public:
    ISIStreamWrapper(IStream& is) : is(is) {
      //std::cout << "Made a new ISIStreamWrapper " << std::endl;
    }

    virtual ~ISIStreamWrapper() {}
    
    virtual ISistream & operator>>(char *str) {
      //std::cout << "char* " << std::endl;
      is >> str;
      return *this;
    }

    virtual ISistream & operator>>(unsigned char *str) {
      //std::cout << "unsigned char* " << std::endl;
      is >> str;
	return *this;
    }

    virtual ISistream & operator>>(char **str) {
      //std::cout << "char** " << std::endl;
        is >> str;
	return *this;
    }

    virtual ISistream & operator>>(unsigned char **str)  {
      //std::cout << "u char** " << std::endl;
        is >> str;
	return *this;
    }

    virtual ISistream & operator>>(bool& val) {
      //std::cout << "bool " << std::endl;
        is >> val;
        return *this;
    }

    virtual ISistream & operator>>(char& val) {
      //std::cout << "char " << std::endl;
        is >> val;
        return *this;
    }

    virtual ISistream & operator>>(unsigned char& val) {
      //std::cout << "uchar " << std::endl;
        is >> val;
        return *this;
    }

    virtual ISistream & operator>>(short& val) {
      //std::cout << "short " << std::endl;
        is >> val;
        return *this;
    }

    virtual ISistream & operator>>(unsigned short& val) {
      //std::cout << "ushort " << std::endl;
        is >> val;
        return *this;
    }

    virtual ISistream & operator>>(int& val) {
      //std::cout << "int " << std::endl;
        is >> val;
        return *this;
    }

    virtual ISistream & operator>>(unsigned int& val) {
	//std::cout << "uint" << std::endl;
        is >> val;
        return *this;
    }

    virtual ISistream & operator>>(long& val)  {
	//std::cout << "val" << std::endl;
        is >> val;
        return *this;
    }

    virtual ISistream & operator>>(unsigned long& val) {
	//std::cout << "ulong " << std::endl;
        is >> val;
        return *this;
    }

    virtual ISistream & operator>>(float& val) {
	//std::cout << "float " << std::endl;
        is >> val;
        return *this;
    }

    virtual ISistream & operator>>(double& val) {
	//std::cout << "double " << std::endl;
        is >> val;
        return *this;
    }

    virtual ISistream & operator>>(std::string& val) {
	//std::cout << "std::string " << std::endl;
        is >> val;
        return *this;
    }

    //    virtual ISistream & operator>>(OWLDate& val) = 0;
    //    virtual ISistream & operator>>(OWLTime& val) = 0;


    virtual ISistream & get ( bool ** p, size_t & size ) {
      is.get(p,size);
      return *this;
    }

    virtual ISistream & get ( char ** p, size_t & size ) {
      is.get(p,size);
      return *this;
    }

    virtual ISistream & get ( unsigned char ** p, size_t & size ) {
      is.get(p,size);
      return *this;
    }

    virtual ISistream & get( short ** p, size_t & size ) {
	is.get(p,size);
	return *this;
    }

    virtual ISistream & get( unsigned short ** p, size_t & size ) {
	is.get(p,size);
        return *this;
    }

    virtual ISistream & get( int ** p, size_t & size ) {
	is.get(p,size);
        return *this;
    }

    virtual ISistream & get( unsigned int ** p, size_t & size ) {
      is.get(p,size);
      return *this;
    }

    virtual ISistream & get( long ** p, size_t & size ) {
      is.get(p,size);
      return *this;
    }

    virtual ISistream & get( unsigned long ** p, size_t & size ) {
      is.get(p,size);
      return *this;
    }

    virtual ISistream & get( float ** p, size_t & size ) {
	is.get(p,size);
        return *this;
    }

    virtual ISistream & get( double ** p, size_t & size ) {
      is.get(p,size);
      return *this;
    }

    virtual ISistream & get( std::string ** p, size_t & size ) {
	is.get(p,size);
        return *this;
    }

    virtual ISistream & get( bool * const p, const size_t size ) {
      is.get(p,size);
      return *this;
    }

    virtual ISistream & get( char * const p, const size_t size ) {
        is.get(p,size);
	return *this;
    }

    virtual ISistream & get( unsigned char * const p, const size_t size ) {
        is.get(p,size);
	return *this;
    }

    virtual ISistream & get( short * const p, const size_t size ) {
        is.get(p,size);
	return *this;
    }

    virtual ISistream & get( unsigned short * const p, const size_t size ) {
        is.get(p,size);
	return *this;
    }
    
    virtual ISistream & get( int * const p, const size_t size ) {
        is.get(p,size);        
	return *this;
    }

    virtual ISistream & get( unsigned int * const p, const size_t size ) {
        is.get(p,size);        
	return *this;
    }

    virtual ISistream & get( long * const p, const size_t size ) {
        is.get(p,size);
	return *this;
    }

    virtual ISistream & get( unsigned long * const p, const size_t size ) {
        is.get(p,size);
        return *this;
    }

    virtual ISistream & get( float * const p, const size_t size ) {
        is.get(p,size);
        return *this;
    }

    virtual ISistream & get( double * const p, const size_t size ) {
        is.get(p,size);
        return *this;
    }

    virtual ISistream & get( std::string * const p, const size_t size ) {
        is.get(p,size);
        return *this;
    }
  private:
    ISIStreamWrapper();
    IStream& is;
  };

} // namespace Sct

#endif // #ifndef SCT_ISISTREAMWRAPPER_H
