#ifndef SCT_IS_OSTREAMIS_H
#define SCT_IS_OSTREAMIS_H

#include <is/isinfo.h>
#include "../OStream.h"

namespace Sct {
namespace IS {
    
  /* An OStream for writing to the information service */
class OStreamIS : public virtual OStream {
public:
    OStreamIS(ISostream& out) : out(out) {}
    
    virtual OStream & operator<<(bool val) {
	out << val;
	return *this;
    }
    
    virtual OStream & operator<<(char val) {
	out << val;
	return *this;
    }
    
    virtual OStream & operator<<(unsigned char val) {
	out << val;
	return *this;
    }
    
    virtual OStream & operator<<(short val) {
	out << val;
	return *this;
    }
    
    virtual OStream & operator<<(unsigned short val) {
	out << val;
	return *this;
    }
    
    virtual OStream & operator<<(int val) {
	out << val;
	return *this;
    }
    
    virtual OStream & operator<<(unsigned int val) {
	out << val;
	return *this;
    }
    
    virtual OStream & operator<<(long val) {
	out << val;
	return *this;
    }
    
    virtual OStream & operator<<(unsigned long val) {
	out << val;
	return *this;
    }
    
    virtual OStream & operator<<(double val) {
	out << val;
	return *this;
    }
    
    virtual OStream & operator<<(float val) {
	out << val;
	return *this;
    }
    
    virtual OStream & operator<<(const std::string & val) {
	out << val;
	return *this;
    }
    
    virtual OStream & operator<<(OWLDate & val) {
	out << val;
	return *this;
    }
    
    virtual OStream & operator<<(OWLTime & val) {
	out << val;
	return *this;
    }
    

    virtual OStream & operator<<(const char * str) {
	out << str;
	return *this;
    }
    
    virtual OStream & operator<<(const unsigned char * str)  {
	out << str;
	return *this;
    }
    
    
    virtual OStream & put(const bool* p, size_t size) {
	out.put(p, size);
	return *this;
    }
    
    virtual OStream & put(const char* p, size_t size){
	out.put(p, size);
	return *this;
    }
    
    virtual OStream & put(const unsigned char* p, size_t size) {
	out.put(p, size);
	return *this;
    }
    
    virtual OStream & put(const short* p, size_t size) {
	out.put(p, size);
	return *this;
    }
    
    virtual OStream & put(const unsigned short* p, size_t size) {
	out.put(p, size);
	return *this;
    }
    
    virtual OStream & put(const int* p, size_t size) {
	out.put(p, size);
	return *this;
    }
    
    virtual OStream & put(const unsigned int* p, size_t size) {
	out.put(p, size);
	return *this;
    }
    
    virtual OStream & put(const long* p, size_t size) {
	out.put(p, size);
	return *this;
    }
    
    virtual OStream & put(const unsigned long* p, size_t size) {
	out.put(p, size);
	return *this;
    }
    
    virtual OStream & put(const float* p, size_t size) {
	out.put(p, size);
	return *this;
    }
    
    virtual OStream & put(const double* p, size_t size) {
	out.put(p, size);
	return *this;
    }
    
    virtual OStream & put(const std::string* p, size_t size) {
	out.put(p, size);
	return *this;
    }
    
    virtual OStream & put(const OWLDate* p, size_t size) {
	out.put(p, size);
	return *this;
    }
    
    virtual OStream & put(const OWLTime* p, size_t size) {
	out.put(p, size);
	return *this;
    }
    
    
private:
    ISostream& out;
};
}
}
#endif //SCT_IS_OSTREAMIS_H
