#ifndef SCT_IONAME_H
#define SCT_IONAME_H

#include "LogicErrors.h"

namespace Sct {


class IOName {
public:
    IOName(const string& nameIO) throw(InvalidArgumentError);
    IOName(const string& uniqueID, const string& className) throw(InvalidArgumentError);
    virtual ~IOName() throw();
    
    string getIOName() const throw();
    string getUniqueID() const throw();
    string getClassName() const throw();

    /** return true if this name contains wildcards*/
    virtual bool wildcard() const;
    typedef std::list<shared_ptr<IOName> >::iterator iterator;
    typedef std::list<shared_ptr<IOName> >::const_iterator const_iterator;
    /** iterator begin method*/ 
    iterator begin();
    /** iterator end method for wildcard */
    iterator end();
    /** iterator const begin method for wildcard */
    const_iterator begin() const;
    /** iterator const end method for wildcard */
    const_iterator end() const;
 protected: protected:
    /**
      Must set uniqueID from nameIO.
      @throw InvalidArgument if this isn't possible.
      */
    virtual void parse() throw(InvalidArgumentError) = 0;
    
    /**
      Must set nameIO from uniqueID and className.
      */
    virtual void construct() throw() = 0;
    
    /**
       expand all wildcards - to be over-written by sub-classes.
     */
    virtual void expandWildcards();
    string uniqueID;
    string className;
    string nameIO;
    std::list<shared_ptr<IOName> > m_list;
    mutable bool m_wildcardsExpanded;
    IOName() {}
};

}

#endif //SCT_IONAME_H
