#include "Env.h"
#include <cstdlib>
#include <iostream>

using namespace std;

namespace Sct {

//Internal private functions:

//Substitutes a single variable
size_t substituteVariable(string& str, size_t startPos) {
    size_t start = str.find("${", startPos);
    if (start == string::npos) return string::npos;
    size_t end = str.find('}', start+2);
    if (end == string::npos) return string::npos;

    string varName = str.substr(start+2, end-start-2);
    char* varValue = getenv(varName.c_str());
    if (varValue == NULL) return end;

    str.replace(start, end-start+1, varValue);

    return end;
}


string Env::substituteVariables(string str) {
    size_t pos = 0;
    while ((pos = substituteVariable(str, pos)) != string::npos) {}
    return str;
}

}
