package Sct.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Box;


/**
   A dialog for entering multiple items
 */
public class MultiSelectionDialog extends JDialog {
    String selections[];
    int enabled[];

    boolean valid;

    public static String[] showDialog(java.awt.Component owner, 
                                      String title, String[] selections, int[] enabled) {
        MultiSelectionDialog dia = new MultiSelectionDialog(owner, title, selections, enabled);
        dia.pack();
        dia.setVisible(true);
        return dia.getSelection();
    }

    /**
       @param owner Parent frame
       @param title Title of dialog box
       @param fs Field names
       @param ds Default text to put in textFields
     */
    public MultiSelectionDialog(java.awt.Component owner, String title, String[] ss, int[] enabled) {
        super(javax.swing.JOptionPane.getFrameForComponent(owner), title, true);

        selections = ss;
        this.enabled = enabled;

        valid = true;

        initComponents();
        modifyComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jPanel2 = new javax.swing.JPanel();
        jPanel3 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        multiList = new javax.swing.JList();
        jPanel1 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();

        jPanel2.setLayout(new javax.swing.BoxLayout(jPanel2, javax.swing.BoxLayout.Y_AXIS));

        jPanel3.setLayout(new java.awt.BorderLayout());

        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        jLabel1.setLabelFor(multiList);
        jLabel1.setText("jLabel1");
        jPanel3.add(jLabel1, java.awt.BorderLayout.WEST);

        jPanel2.add(jPanel3);

        jScrollPane1.setViewportView(multiList);

        jPanel2.add(jScrollPane1);

        jButton1.setText("OK");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jPanel1.add(jButton1);

        jButton2.setText("Cancel");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        jPanel1.add(jButton2);

        jPanel2.add(jPanel1);

        getContentPane().add(jPanel2, java.awt.BorderLayout.NORTH);

    }//GEN-END:initComponents

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        valid = false;
        dispose();
    }//GEN-LAST:event_jButton2ActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        dispose();
    }//GEN-LAST:event_jButton1ActionPerformed

    /**
       Build the GUI panel
     */
    private void modifyComponents() {
        multiList.setListData(selections);
        multiList.setSelectedIndices(enabled);

        jLabel1.setText("Make selections");
    }

    String [] getSelection() {
        if(valid) {
            Object [] vals = multiList.getSelectedValues();
            String [] result = new String[vals.length];
            for(int i = 0; i < vals.length; i++) {
                result[i] = vals[i].toString();
            }
            return result;
        } else {
            return null;
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JList multiList;
    // End of variables declaration//GEN-END:variables


    public static class Test {
        public static void main(String args[]) {
            String objs [] = {"Hello", "World", "1", "2", "3"};

            int sels[] = {0, 1, -1};

            String selected [] = MultiSelectionDialog.showDialog(null, "Test Selection", objs, sels);
            if(selected == null) {
                System.out.println("Dialog cancelled");
            } else {
                for(int i = 0; i < selected.length; i++) {
                    System.out.println(i + ": " + selected[i]);
                }
            }

            System.exit(0);
        }
    }
}
