/*
 * Version.java
 *
 * Created on 21 October 2003, 12:24
 */

package Sct;

import java.util.regex.*;

/**
 * This class provides access to the properties about what version this is
 * @author  Matthew Palmer
 */
public final class Version extends java.util.Properties {
    
    public final static Version instance = new Version();
    
    public String getVersionName() {
        return version;
    }
    
    public double getVersion() {
        return versionNumber;
    }
    
    public int getMajorVersion() {
        return majorVersion;        
    }
    
    public int getMinorVersion() {
        return minorVersion;
    }
    
    //{
    /**@name Convenience methods.
     * May also be accessed by using the appropriate property name.
     * These methods will not return null, they will return some default.
     * Use getProperty if you do not like this behaviour
     */        
    
    ///Get information about the build system
    public String getBuildSystem() {
        return getProperty("Sct.BuildSystem", "No information available");
    }
    ///Get information about the build host
    public String getBuildHost() {
        return getProperty("Sct.BuildHost", "No information available");
    }
    ///Get information about the build date
    public String getBuildDate() {
        return getProperty("Sct.BuildDate", "No information available");
    }
    ///Get Cmt config string
    public String getCmtConfig() {
        return getProperty("Sct.CmtConfig", "No information available");
    }
    ///Get the version of the Online Software this was compiled with
    public String getOnlineVersion() {
        return getProperty("Sct.OnlineVersion", "No information available");
    }
    ///Get the version of ROOT this was compiled with
    public String getRootVersion() {
        return getProperty("Sct.RootVersion", "No information available");
    }
    ///Get the version of gcc this was compiled with
    public String getGccVersion() {
        return getProperty("Sct.GccVersion", "No information available");
    }
    ///Get the version of RodDaq this was compiled with
    public String getRodDaqVersion() {
        return getProperty("Sct.RodDaqVersion", "No information available");
    }
    ///Get the version of DataFlow this was compiled with
    public String getDataFlowVersion() {
        return getProperty("Sct.DataFlowVersion", "No information available");
    }
    
    ///Returns a string containing all the build information in a pre-formatted string
    public String getAllInformation() {
	String s = "System version: " + getVersion() + " named " + getVersionName();
        s += "\n\nBuild Information\nBuild System: " + getBuildSystem() + "\nBuild Host: " + getBuildHost();
        s += "\nBuild Date: " + getBuildDate() + "\nCmtConfig: " + getCmtConfig() + "\nRodDaq Version: ";
	s += getRodDaqVersion() + "\nDataFlow Version: " + getDataFlowVersion() + "\nOnline Version: ";
        s += getOnlineVersion() + "\nRoot Version: " + getRootVersion() + "\nGcc Version: " + getGccVersion();
	return s;
    }
    
    //}
    
    /** Creates a new instance of Version */
    private Version() {
        java.io.InputStream is = getClass().getClassLoader().getResourceAsStream("Sct/version.properties");
        if (is != null) {
            try {
                this.load(is);
            } catch (java.io.IOException e) {
                //Ignore this error as well
                ///@todo Should we have a way of logging exceptions?
            }
        }

        String tag = getProperty("Sct.TagName");
        if (tag != null && tag.length() > 7) {
            version = tag.substring(7, tag.length()-1);
        } else {
            version = "SctRodDaq_0_0_Exp";
        }

	try {
	    System.out.println(version);
	    Matcher m = Pattern.compile("\\p{Alpha}+_(\\d+_\\d+).*").matcher(version);
	    if (m.matches()) {
		String v = m.group(1);
		v = v.replace('_', '.');
		versionNumber = Double.parseDouble(v);
	    }
        } catch (NumberFormatException e) {
            //Do nothing - stay with negative version numbers.
        }
	majorVersion = (int)Math.floor(versionNumber);
	minorVersion = (int)Math.floor((versionNumber - majorVersion)*101);
    }
    
    private String version;
    private double versionNumber = 0.0;
    private int majorVersion = -1;
    private int minorVersion = -1;
}
