/*
 * NameFile.java
 *
 * Created on 29 October 2003, 15:16
 */

package Sct.File;

import Sct.*;
import java.util.*;
import java.util.regex.*;

/**
 * Represents a filename containing a Serializable
 * @author  Matthew Palmer
 */
public class NameFile extends Sct.Name {
    
    public NameFile(Serializable s) {
        this(s.getClassName(), s.getUniqueID());
    }
    
    public NameFile(String name) throws IllegalArgumentException {
        super(name);        
        fileName = name;
    }
    
    public NameFile(String className, String uniqueID) {
        super(className, uniqueID);        
        path = getDefaultPath();
        construct();
    }
    
    public String getName() {        
        return fileName;
    }
    
    public String getPath() {
        return path;
    }

    /**
     * This needs to be called if the System properties are changes
     */
    public static void reset() {
        fileNamePattern = null;
        defaultPath = null;
    }
    
    /**
     * Format <path>/className.uniqueID
     */
    protected void parse(String name) throws IllegalArgumentException {
        try {
            Matcher m = getPattern().matcher(name);
	    m.matches();
	    path = m.group(1);
	    className = convertFromC(m.group(2));
	    uniqueID = m.group(3);
	} catch (IllegalStateException e) {
	    IllegalArgumentException iae = new IllegalArgumentException("NameFile cannot parse File name - doesn't match expected format: " + name);   
	    iae.initCause(e);
	    throw iae;
	} catch (IndexOutOfBoundsException e) {
	    IllegalStateException iae = new IllegalStateException("NameFile internal error - regex does have expected number of groups.  Name: " + name);   
	    iae.initCause(e);
	    throw iae;
	}
    }
    
    // This is used by the Unit tests
    public static String getDefaultPath() {
        if (defaultPath == null) {
            defaultPath = System.getProperty("Sct.Scratch.Dir", "/tmp");
        }
        return defaultPath;
    }
    
    private void construct() {
        fileName = getPath() + "/" + convertToC(className) + "." + uniqueID;
    }
    
    private static Pattern getPattern() {
        if (fileNamePattern == null) 
            fileNamePattern = Pattern.compile("(.*)/([\\S&&[^.]]*)\\.(.*)");
        return fileNamePattern;
    }
    
    private static Pattern fileNamePattern;
    private static String defaultPath;
    private String path;
    private String fileName;
}
