// File: RodStatus.cxx
// $Header: /afs/cern.ch/user/s/sctpixel/private/cvsroot/RodDaq/RodCrate/RodStatus.cxx,v 1.2 2002/12/12 21:25:53 tmeyer Exp $

//! Namespace for the common routines for SCT and PIXEL ROD software.

#include "RodStatus.h"

namespace SctPixelRod {

// Constructors
    ostream& RodStatus::operator<<(ostream& os, RodModule& rod) {
    os << "Slot: " << rod->getSlotNumber();
    os << "Serial Number:" << rod->getSerialNumber();
    os << "Number of slave DSPs: " << getNumSlaves();
    os << endl;
    hex(os);
    os << "Status registers[0-2]: " << rod.readRodStatusReg(0) << " " <<
             rod.readRodStatusReg(1) << " " << rod.readRodStatusReg(2) << endl;
    os << "Command registers[0-1]: " << rod.readRodCommandReg(0) << " " <<
             rod.readRodCommandReg(1) << endl;
    dec(os);
    os << "Primitive state: " << rod.getPrimState() << " Text State: " << 
          rod.getTextState();
    os << endl;
    return os;
  }

// RodStatus contains the status information for a ROD. For now it does very
// little.
//
// @author Tom Meyer (meyer@iastate.edu) - originator
//
  void RodStatus::snapShot(RodModule &rod) {
    m_slotNumber = rod.getSlot();
    m_serialNumber = rod.getSerialNumber();
    m_numSlaves = rod.getNumSlaves();
    for (long i=0; i<3; i++) {
      m_statusReg[i] = rod.readRodStatusReg(i);
  }
    for (long i=0; i<2; i++) {
      m_commandReg[i] = rod.readRodCommandReg(i);
    }
    m_primState = rod.getPrimState();
    m_textState = rod.getTextState();
    return;
  };
} // End namespace SctPixelRod
