//File: RodDspAddresses.h

#ifndef SCTPIXELROD_RODDSPADDRESSES_H 
#define SCTPIXELROD_RODDSPADDRESSES_H

/*!
 * RodDspAddresses.h is a wrapper around the testBench C code header file
 * memoryPartitions.h. This wrapper adapts things to appear more like C++ and to
 * declare things const so the compiler can catch attempts to change them in the
 * code.
 *
 * It also has hard-coded slave addresses which are needed by initSlaveDsp().
 *
 * Use only the names declared in this file when writing C++ code.
 *
 * @author T. Meyer (meyer@iastate.edu)
 */

namespace SctPixelRod {

#include "processor.h"
#include "memoryPartitions.h"

// Use only the names in this file in C++ code.

// Give some shorter aliases to the primitive list and reply list buffers
const unsigned long PRIM_BUFF_BASE = MDSP_PRM_BFR_BASE;
const unsigned long PRIM_BUFF_SIZE = MDSP_PRM_BFR_SZ;
const unsigned long REPLY_BUFF_BASE = MDSP_REP_BFR_BASE;
const unsigned long REPLY_BUFF_SIZE = MDSP_REP_BFR_SZ;

// Give aliases to text buffers
const unsigned long TEXT_BUFF_SIZE = TXT_BFR_SZ;
const unsigned long ERR_BUFF_BASE = ERR_BFR_BASE;
const unsigned long INFO_BUFF_BASE = INFO_BFR_BASE;
const unsigned long DIAG_BUFF_BASE = DIAG_BFR_BASE;
const unsigned long XFER_BUFF_BASE = XFER_BFR_BASE;

// Give aliases to VmeCommand and RodStatus registers
const unsigned long STATUS_REG[3] = {STATUS_REG_0, STATUS_REG_1, STATUS_REG_2};
const unsigned long COMMAND_REG[2] = {COMMAND_REG_0, COMMAND_REG_0};

// Define slave DSP addresses for initializing and direct HPI communication
// with slave
const unsigned long SLAVE_HPIC_BASE = 0x00780000;
const unsigned long SLAVE_HPIA_BASE = SLAVE_HPIC_BASE+0x4;
const unsigned long SLAVE_HPID_AUTO_BASE = SLAVE_HPIC_BASE+0x8;
const unsigned long SLAVE_HPID_NOAUTO_BASE = SLAVE_HPIC_BASE+0xC;
const unsigned long SLAVE_HPI_OFFSET = 0x20000;

const unsigned long SLAVE_EMIF_ADDR =0x01800010;
const unsigned long SLAVE_IPRAM_ADDR = 0x00000000;
const unsigned long SLAVE_IDRAM_ADDR = 0x80000000;
const unsigned long SLAVE_CE2_ADDR = 0x02000000;

const unsigned long SLAVE_PRIM_BUFF_SIZE = SDSP_PRM_BFR_SZ;
const unsigned long SLAVE_REPLY_BUFF_SIZE = SDSP_REP_BFR_SZ;
const unsigned long SLAVE_PRIM_BUFF_BASE = SDSP_PRM_BFR_BASE;
const unsigned long SLAVE_REPLY_BUFF_BASE = SDSP_REP_BFR_BASE;

// Define DSP reset timeout
const long DSP_RESET_TIMEOUT = 30;

} //  End namespace SctPixelRod

#endif // SCTPIXELROD_RODDSPADDRESSES_H
