#include <iostream>

#include <ctype.h>

#include <unistd.h>

#include "RodModule.h"

#include "RCCVmeInterface.h"

using namespace std;
using namespace SctPixelRod;

void usage();

int main(int argc, char **argv) {

  const unsigned long mapSize=0xc00040;         // Map size
  const long numSlaves=4;                       // Number of slaves

  int slot = -1;
  int fpga = 0;
  unsigned long baseAddress;

  if (argc > 1) {
    for (int i=1; i<argc; i++) {
      string option;
      option = argv[i];
      if (option[0] != '-') break;
      switch (option[1]) {
        case 's': {
          slot = atoi(option.substr(2).c_str());
          break;
        }
        case 'f': {
          fpga = 1;
          break;
        }
        case 'h': {
          usage();
          exit(0);
          break;
        }
        default: {
          break;
        }
      }
    }
  }

// Prompt for slot number
  if (slot < 0) {
    cout << "Enter slot number (decimal):"; 
    cin >> slot;
    while ((slot < 1) || (slot > 21)) {
      cout << "Slot number out or range [1:21], re-enter: ";
      cin >> slot;
    }
  }
  baseAddress = slot << 24;
  
// Create VME interface
  RCCVmeInterface *vme = new RCCVmeInterface();
  
// Create RodModule and initialize it
  RodModule* rod = new RodModule(baseAddress, mapSize, *vme, numSlaves);

//   unsigned long int mdspReset = 0x2;   // All sdsps + mdsp

  unsigned long int fpgaReset = 0x20;     // Reconfigure FPGAs
  unsigned long int mdspReset = 0x40;     // All sdsps + mdsp

  unsigned long resetAddress;
  unsigned long resetValue;

  if(fpga) {
    resetAddress = FPGA_CONTROL_REG_REL_ADDR[0];
    resetValue = fpgaReset;
  } else {
    resetAddress = FPGA_CONTROL_REG_REL_ADDR[2];
    resetValue = mdspReset;
  }

  hex(cout);

  cout << "Reset\n";
  cout << "Reset addresss: 0x" << resetAddress << endl;
  rod->getVmePort()->write32(resetAddress, resetValue);

  cout << "Set value: 0x" << rod->getVmePort()->read32(resetAddress) << endl;
//   rod->getVmePort()->write32(resetAddress, 0x00);
//   cout << "Reset value: 0x" << rod->getVmePort()->read32(resetAddress) << endl;

  dec(cout);

//  cout << "Sleep\n";
//    sleep(3);

//  cout << "Rod Reset\n";
//    rod->reset();

//    try { 
//      rod->resetMasterDsp();
//    } catch(...) {
//      cout << "Exception during reset\n";
//    }

// Clean up before exiting
  delete rod;
  delete vme;

  return 0;  
}

void usage() {
  cout << "Usage: ResetRod [options]\n";
  cout << "\t-s# Reset ROD in slot # (decimal)\n";
  cout << "\t-f Reconfigure the FPGAs instead of resetting the DSPs\n";
}
