/*
 * SCTInterface.java
 *
 * Created on 15 November 2002, 12:01
 */

package GuiComponents.System;

import ipc.*;
import java.util.*;
import java.util.logging.*;
import SctTestApi.*;
import Sct_CalibrationController.*;
import Sct_SctApi.*;
import AnalysisServiceI.*;
import ArchivingServiceI.*;
import sctConf.*;
import FitterI.*;


/**
 * This class is an interface to the rest of the Software System
 * It contains methods to get access to all the various components that
 * may or may not be running.
 *
 * Users should probably not cache references for long periods of time
 *
 * This class and ISInterface mirror some of the methods from SctNames in the C++ code
 *
 * @author Matthew Palmer
 */
public class SystemInterface {    
    
    /**
     * Get the singleton interface.
     */
    public static SystemInterface getInstance() {
        return instance;
    }

    /**
     * Re-obtain all connections to external processes.
     */
    public void refresh() {
        p = null;               
        testconfig = null;
        highlevel = null;
        cc = null; 
        api = null;
        config = null;
        analysis = null;
	archiving = null;
        fitter = null;
    }

    /**
     * Get the IPC Partition that all our processes are contained in.
     */
    public Partition getPartition() {
	if (p == null) {
	    try {
		p = new Partition(partitionName); 
	    } catch (PartitionNotFoundException e) {
		logger.info("Failed to get partition: " + partitionName + ": " + e.getMessage());
	    }
	}
        return p;
    }

    /**
     * Get a reference to the SctTest Configuration interface
     */
    public SctTestApi.Configuration getTestConfiguration() {
        if (testconfig == null) {
            try {
                org.omg.CORBA.Object ob = getPartition().lookup(SctTestApi.Configuration.instanceName, SctApi.serverName);
                testconfig = SctTestApi.ConfigurationHelper.narrow(ob);
		if (testconfig == null) {
		    logger.info("Failed to lookup SctTest::Configuration using: " + SctTestApi.Configuration.instanceName + " and " + SctApi.serverName);
		}
            } catch (org.omg.CORBA.SystemException se) {
		logger.info("Failed to lookup SctTest::Configuration using: " + SctTestApi.Configuration.instanceName + " and " + SctApi.serverName + ". Exception: " + se.getMessage());
	    } catch (NullPointerException npe) {
		//Do nothing - this must have been caused by not being able to get the partition, which we've already logged
	    }
        }
        return testconfig;
    }

    /**
     * Get a reference to the SctTest HighLevelApi interface
     */
    public HighLevelApi getTestHighLevelApi() {
        if (highlevel == null) {
            try {
                org.omg.CORBA.Object ob = getPartition().lookup(HighLevelApi.instanceName, HighLevelApi.serverName);
                highlevel = HighLevelApiHelper.narrow(ob);
		if (highlevel == null) {
		    logger.info("Failed to lookup SctTest::HighLevelApi using: " + HighLevelApi.instanceName + " and " + HighLevelApi.serverName);
		}
            } catch (org.omg.CORBA.SystemException se) {
		logger.info("Failed to lookup SctTest::HighLevelApi using: " + HighLevelApi.instanceName + " and " + HighLevelApi.serverName + ". Exception: " + se.getMessage());
	    } catch (NullPointerException npe) {
		//Do nothing - this must have been caused by not being able to get the partition, which we've already logged
	    }
        }
        return highlevel;
    }


    /**
     * Gets a reference to the CalibrationController
     */
    public CalibrationController getCalibrationController() {
        if (cc == null) {
            try {
                org.omg.CORBA.Object ob = getPartition().lookup(CalibrationController.instanceName, CalibrationController.serverName);
                cc = CalibrationControllerHelper.narrow(ob);
            } catch (org.omg.CORBA.SystemException se) {                
                logger.info("Failed to lookup CalibrationController using: " + CalibrationController.instanceName + " and " + CalibrationController.serverName + ". Exception: " + se.getMessage());
	    } catch (NullPointerException npe) {
		//Do nothing - this must have been caused by not being able to get the partition, which we've already logged
	    }
        }
        return cc;        
    }
    
    /**
     * Gets a reference to the Api
     */
    public SctApi getSctApi() {
        if (api == null) {
            try {
                org.omg.CORBA.Object ob = getPartition().lookup(SctApi.instanceName, SctApi.serverName); 
                api = SctApiHelper.narrow(ob);
            } catch (org.omg.CORBA.SystemException se) {                
                logger.info("Failed to lookup AnalysisService using: " + SctApi.instanceName + " and " + SctApi.serverName + " . Exception: " + se.getMessage());
	    } catch (NullPointerException npe) {
		//Do nothing - this must have been caused by not being able to get the partition, which we've already logged
	    }
        }
        return api;        
    }
    
    /**
     * Gets a reference to the configuration service
     */
    public sctConf.Configuration getConfigurationService() {
        if (config == null) {
            try {
                org.omg.CORBA.Object ob = getPartition().lookup(sctConf.Configuration.instanceName, sctConf.Configuration.serverName);
                config = sctConf.ConfigurationHelper.narrow(ob);
            } catch (org.omg.CORBA.SystemException se) {                
                logger.info("Failed to lookup Configuration using: " + sctConf.Configuration.instanceName + " and " + sctConf.Configuration.serverName + ". Exception: " + se.getMessage());
	    } catch (NullPointerException npe) {
		//Do nothing - this must have been caused by not being able to get the partition, which we've already logged
	    }
        }
        return config;        
    }
    
    /**
     * Gets a reference to the analysis service
     */
    public AnalysisServiceInterface getAnalysisService() {
        if (analysis == null) {
            try {
                org.omg.CORBA.Object ob = getPartition().lookup(AnalysisServiceInterface.instanceName, AnalysisServiceInterface.serverName); 
                analysis = AnalysisServiceInterfaceHelper.narrow(ob);
            } catch (org.omg.CORBA.SystemException se) {                
                logger.info("Failed to lookup AnalysisService using: " + AnalysisServiceInterface.instanceName + " and " + AnalysisServiceInterface.serverName + ". Exception: " + se.getMessage());
	    } catch (NullPointerException npe) {
		//Do nothing - this must have been caused by not being able to get the partition, which we've already logged
	    }
        }
        return analysis;                
    }
    
    /**
     * Gets a reference to the archiving service
     */
    public ArchivingServiceInterface getArchivingService() {
        if (archiving == null) {
            try {
                org.omg.CORBA.Object ob = getPartition().lookup(ArchivingServiceInterface.instanceName, ArchivingServiceInterface.serverName);
                archiving = ArchivingServiceInterfaceHelper.narrow(ob);
            } catch (org.omg.CORBA.SystemException se) {
                logger.info("Failed to lookup ArchivingService using: " + ArchivingServiceInterface.instanceName + " and " + ArchivingServiceInterface.serverName + ". Exception: " + se.getMessage());
            } catch (NullPointerException npe) {
                //Do nothing - this must have been caused by not being able to get the partition, which we've already logged
            }
        }
        return archiving;
    }


    /**
     * Gets a reference to the fitting service
     */
    public FitterInterface getFittingService() {
        if (fitter == null) {
            try {
                org.omg.CORBA.Object ob = getPartition().lookup(FitterInterface.instanceName, FitterInterface.serverName); 
                fitter = FitterInterfaceHelper.narrow(ob);
            } catch (org.omg.CORBA.SystemException se) {                
                logger.info("Failed to lookup Fitter using: " + FitterInterface.instanceName + " and " + FitterInterface.serverName + ". Exception: " + se.getMessage());
	    } catch (NullPointerException npe) {
		//Do nothing - this must have been caused by not being able to get the partition, which we've already logged
	    }
        }
        return fitter;                
    }
    
    /** Creates a new instance of SCTInterface */
    private SystemInterface() {
        logger = Logger.getLogger("GuiComponents.System");     
        refresh();
    }            
    
    private static SystemInterface instance = new SystemInterface();
    private static final String partitionName = "SCT";
    private Partition p;
    private Logger logger;    
    private SctTestApi.Configuration testconfig;
    private HighLevelApi highlevel;
    private CalibrationController cc;
    private SctApi api;
    private sctConf.Configuration config;
    private AnalysisServiceInterface analysis;
    private ArchivingServiceInterface archiving;
    private FitterInterface fitter;
}
