package GuiComponents.SctConf;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;

import org.omg.CORBA.IntHolder;
import org.omg.CORBA.StringHolder;

import sctConf.*;

public class PhysicalView extends JPanel {
    sctConf.Configuration config;

    JComboBox barrel;
    JComboBox rowStart;
    JComboBox rowEnd;

    JPanel centre;

    public PhysicalView(sctConf.Configuration conf) {
        config = conf;

        setLayout(new BorderLayout());

        JPanel buttons = new JPanel();

        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    ((Window)getTopLevelAncestor()).dispose();
                }
            });
        buttons.add(close);

        add(buttons, BorderLayout.SOUTH);

        JPanel combos = new JPanel();

        Integer [] barrelList = {new Integer(3), new Integer(4), new Integer(5), new Integer(6)};

        barrel = new JComboBox(barrelList);
        barrel.setSelectedItem(new Integer(3));
        barrel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
              // Update the list for different barrel number
              ((ComboModel)rowStart.getModel()).fireListeners();
              ((ComboModel)rowEnd.getModel()).fireListeners();
              updateDisplay();
            }
          });
        combos.add(barrel);

        rowStart = new JComboBox(new ComboModel(0));
        //        rowStart.setSelectedItem(new Integer(0));
        rowStart.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
              // For some reason this make the component update afterwards!
              ((ComboModel)rowEnd.getModel()).fireListeners();
              updateDisplay();
            }
          });
        combos.add(rowStart);

        rowEnd = new JComboBox(new ComboModel(3));
        //        rowEnd.setSelectedItem(new Integer(3));
        rowEnd.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
              // For some reason this make the component update afterwards!
              ((ComboModel)rowStart.getModel()).fireListeners();
              updateDisplay();
            }
          });
        combos.add(rowEnd);

        add(combos, BorderLayout.NORTH);

        centre = new JPanel();
        updateDisplay();
        add(centre, BorderLayout.CENTER);
    }

    public void updateDisplay() {
        centre.removeAll();

        centre.setLayout(new GridLayout(1, 4));

        JPanel barrelPanel =  new JPanel();
        barrelPanel.setLayout(new GridLayout(0, 12));

        int b = ((Integer)barrel.getSelectedItem()).intValue();
        int start = ((Integer)rowStart.getSelectedItem()).intValue();
        int end = ((Integer)rowEnd.getSelectedItem()).intValue();

        for(int r=start; r<end; r++) {
            for(int i=-6; i<=6; i++) {
                if(i == 0) continue;

                StringHolder serial = new StringHolder();

                try {
                    IntHolder MUR = new IntHolder();
                    IntHolder mod = new IntHolder();

                    serial = new StringHolder();

                    config.translateFromBarrel(b, r, i, MUR, mod);
                    config.translateToSN(MUR.value, mod.value, serial);
                } catch(ConfigurationException e) {
                    serial.value = "position " + i;
                }

                barrelPanel.add(new JLabel(serial.value + " "));
            }
        }

        centre.add(barrelPanel);
        centre.invalidate();
        barrelPanel.doLayout();
        centre.repaint();
    }

    public class ComboModel implements ComboBoxModel {
        Integer selection;
        java.util.Vector listeners;

        ComboModel(int i) {
            selection = new Integer(i);
            listeners = new java.util.Vector();
        }

        public Object getSelectedItem() {
            return selection;
        }

        public void setSelectedItem(Object select) {
            selection = (Integer)select;
        }

        public void addListDataListener(ListDataListener l) {
            listeners.add(l);
        }

        public Object getElementAt(int index) {
            return new Integer(index);
        }
        public int getSize() {
            int numRows = 0;
            switch(((Integer)barrel.getSelectedItem()).intValue()) {
            case 3: numRows = 32; break;
            case 4: numRows = 40; break;
            case 5: numRows = 48; break;
            case 6: numRows = 56; break;
            }

            return numRows;
        }

        public void fireListeners() {
            for(int i=0; i<listeners.size(); i++) {
                ListDataEvent event = new ListDataEvent(this, ListDataEvent.CONTENTS_CHANGED, 0, 56);
                ((ListDataListener)listeners.get(i)).contentsChanged(event);
            }
        }

        public void removeListDataListener(ListDataListener l) {
          listeners.remove(l);
        }
    }
}
