package GuiComponents.SctConf;

import sctConf.*;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

import Sct.gui.SelectionDialog;

import org.omg.CORBA.IntHolder;

public class ModuleView extends JPanel {
    sctConf.Configuration config;
    Proxies.ModuleProxy module;

    public ModuleView(sctConf.Configuration conf, Proxies.ModuleProxy mod) {
        module = mod;
        config = conf;

        buildGUI();
    }

    void buildGUI() {
        removeAll();

        setLayout(new BorderLayout());

        JPanel buttons = new JPanel();

        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    ((Window)getTopLevelAncestor()).dispose();
                }
            });
        buttons.add(close);

        add(buttons, BorderLayout.SOUTH);

        Box centre = Box.createVerticalBox();

        centre.add(new JLabel(module.toString()));
        centre.add(getMURPanel());
        centre.add(getRODPanel());
        centre.add(new JLabel(module.getRRODString()));
        centre.add(getPhysicalPanel());
        centre.add(getPowerPanel());

        add(centre, BorderLayout.CENTER);
    }

    JPanel getMURPanel() {
        JPanel panel = new JPanel();
        panel.add(new JLabel(module.getMURString()));

        JButton button = new JButton("Edit MUR Mapping");
        button.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    String [] labels = {"MUR id", "Position (1-6)", "Redundant MUR id", "Position on redundant MUR (1-6)"};
                    String [] defaults = {"0", "1", "0", "1"};

                    try {
                        IntHolder MUR = new IntHolder(), num = new IntHolder();
                        config.translateFromSN(module.getSN(), MUR, num);

                        defaults[0] = "" + MUR.value;
                        defaults[1] = "" + num.value;

                        IntHolder RMUR = new IntHolder(), rnum = new IntHolder();
                        config.translateToRMUR(MUR.value, num.value, RMUR, rnum);

                        defaults[2] = "" + RMUR.value;
                        defaults[3] = "" + rnum.value;
                    } catch(ConfigurationException c) {
                        // Leave as zeros
                    }

                    SelectionDialog dia = new SelectionDialog(null, "Edit Power mapping", labels, defaults);

                    dia.pack();
                    dia.setVisible(true);

                    try {
                        for(int i=0; i<4; i++) {
                            System.out.println(labels[i] + ": " + dia.getIntFieldValue(i));
                        }

                        try {
                            config.mapModuleMUR(dia.getIntFieldValue(0), dia.getIntFieldValue(1), 
                                                dia.getIntFieldValue(2), dia.getIntFieldValue(3), 
                                                module.getSN());
                        } catch(ConfigurationException cex) {
                            JOptionPane.showMessageDialog(null, "Failed to remap module to MUR: " + cex.detail);
                            return;
                        }

                        buildGUI();
                        validate();
                    } catch(SelectionDialog.InvalidDialogException i) {
                        JOptionPane.showMessageDialog(null, "Failed to interpret entry(ies)");
                    } catch(SelectionDialog.CancelledDialogException i) {
                        // Cancel pressed
                    }
                }
            });
        panel.add(button);
        return panel;
    }

    JPanel getRODPanel() {
        JPanel panel = new JPanel();
        panel.add(new JLabel(module.getRODString()));

        panel.add(new JLabel("Not editable at module level"));

//         JButton button = new JButton("Edit");
//         button.addActionListener(new ActionListener() {
//                 public void actionPerformed(ActionEvent e) {
//                     String [] labels = {"Partition", "Crate", "ROD", "Channel"};
//                     SelectionDialog dia = new SelectionDialog(null, "Edit ROD mapping", labels);

//                     dia.pack();
//                     dia.setVisible(true);

//                     for(int i=0; i<4; i++) {
//                         System.out.println(labels[i] + ": " + dia.getIntFieldValue(i));
//                     }
//                 }
//             });
//         panel.add(button);
        return panel;
    }

    JPanel getPowerPanel() {
        JPanel panel = new JPanel();
        panel.add(new JLabel(module.getPowerString()));

        JButton button = new JButton("Edit Power Mapping");
        button.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    String [] labels = {"Partition", "Crate", "Channel (0-47)"};
                    String [] defaults = {"0", "0", "0"};

                    try {
                        IntHolder MUR = new IntHolder(), num = new IntHolder();
                        config.translateFromSN(module.getSN(), MUR, num);

                        IntHolder partition = new IntHolder(), crate = new IntHolder(), 
                            channel = new IntHolder();
                        config.translateToPowerSupply(MUR.value, num.value, partition, crate, channel);
                        defaults[0] = "" + partition.value;
                        defaults[1] = "" + crate.value;
                        defaults[2] = "" + channel.value;
                    } catch(ConfigurationException c) {
                        // Leave as zeros
                    }

                    SelectionDialog dia = new SelectionDialog(null, "Edit Power mapping", labels, defaults);

                    dia.pack();
                    dia.setVisible(true);

                    try {
                        for(int i=0; i<3; i++) {
                            System.out.println(labels[i] + ": " + dia.getIntFieldValue(i));
                        }

                        IntHolder MUR = new IntHolder(), num = new IntHolder();
                        try {
                            config.translateFromSN(module.getSN(), MUR, num);
                        } catch(ConfigurationException cex) {
                            JOptionPane.showMessageDialog(null, "No mapping to MUR! (db inconsistent)");
                            return;
                        }

                        try {
                            config.mapPowerChannel(MUR.value, num.value, 
                                                   dia.getIntFieldValue(0), dia.getIntFieldValue(1), dia.getIntFieldValue(2));
                        } catch(ConfigurationException cex) {
                            JOptionPane.showMessageDialog(null, "Failed to map Power Channel: " + cex.detail);
                            return;
                        }

                        buildGUI();
                        validate();
                    } catch(SelectionDialog.InvalidDialogException i) {
                        JOptionPane.showMessageDialog(null, "Failed to interpret entry(ies)");
                    } catch(SelectionDialog.CancelledDialogException i) {
                        // Cancel pressed
                    }
                }
            });
        panel.add(button);
        return panel;
    }


    JPanel getPhysicalPanel() {
        JPanel panel = new JPanel();
        panel.add(new JLabel(module.getPhysicalString()));

        panel.add(new JLabel("Not editable at module level"));

        return panel;
    }
}
