package GuiComponents.SctConf;

import javax.swing.event.AncestorListener;
import javax.swing.event.AncestorEvent;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

import java.io.File;

import java.util.Vector;

import org.omg.CORBA.IntHolder;
import org.omg.CORBA.StringHolder;

import sctConf.*;
import Sct.gui.SelectionDialog;

public class MURPanel extends JPanel {
    sctConf.Configuration config;
    Proxies.RodProxy rod;

    int mur;
    int order;

//    boolean editable;

    // ChannelPanel [] channels;

    /// If type is 1 then read only sub-panel otherwise editable
    public MURPanel(Configuration conf, Proxies.RodProxy r, int o) {
        rod = r;
        config = conf;
        order = o;

        try {
            IntHolder MUR = new IntHolder();

            config.getMapRODMUR(rod.partition(), rod.crate(), rod.index(), order, MUR);
            mur = MUR.value;
        } catch(NullPointerException e) {
            mur = 1;
        } catch(ConfigurationException e) {
            mur = -1;
        }

        if(mur == -1) {
            try {
                int newMUR = config.getFreeMurId();
                if(config.getMURType(newMUR) == sctConf.MURType.UNKNOWN) {
                    config.mapRODMUR(rod.partition(), rod.crate(), rod.index(), order, newMUR);
                }
                mur = newMUR;
            } catch(ConfigurationException cex) {
                JOptionPane.showMessageDialog(null, "Failed to map new MUR to ROD: " + cex.detail);
                return;
            }
        }

        initComponents();
        modifyComponents();
    }

    public static void main(String args[]) {
        JFrame frame = new JFrame("Test MUR Panel");
        frame.getContentPane().add(new MURPanel(null, null, 1));
        frame.pack();
        frame.setVisible(true);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        murBox = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();
        chanBox = new javax.swing.JPanel();
        chanBox2 = new javax.swing.JPanel();

        setLayout(new java.awt.BorderLayout());

        setBorder(new javax.swing.border.TitledBorder(getTitleString()));
        murBox.setLayout(new javax.swing.BoxLayout(murBox, javax.swing.BoxLayout.X_AXIS));

        jButton1.setText("Edit Physical Mapping");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                physicalMappingPerformed(evt);
            }
        });

        murBox.add(jButton1);

        add(murBox, java.awt.BorderLayout.SOUTH);

        jPanel1.setLayout(new java.awt.GridLayout(1, 2));

        chanBox.setLayout(new java.awt.GridLayout(3, 1));

        jPanel1.add(chanBox);

        chanBox2.setLayout(new java.awt.GridLayout(3, 1));

        jPanel1.add(chanBox2);

        add(jPanel1, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents

    private void physicalMappingPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_physicalMappingPerformed
        String [] labels;

        String [] defaults = {"", "", ""};

        int type = 0;

        IntHolder plane = new IntHolder(), section = new IntHolder(), position = new IntHolder();

        MURType mType;
        try {
            mType = config.getMapMURPhysical(mur, plane, section, position);
        } catch(ConfigurationException c) {
            mType = sctConf.MURType.UNKNOWN;
        }

        if(mType == sctConf.MURType.BARREL) {
            defaults[0] = "" + plane.value;
            defaults[1] = "" + section.value;
            defaults[2] = "" + position.value;
            type = 1;
        } else if(mType == sctConf.MURType.ENDCAP) {
            defaults[0] = "" + plane.value;
            defaults[1] = "" + section.value;
            defaults[2] = "" + position.value;
            type = 2;
        } else {
            // No mapping yet
            Object[] possibilities = {"Barrel", "Endcap"};
            String s = (String)JOptionPane
                        .showInputDialog(null,  // Frame
                                         "Select a type for this MUR:",
                                         "MUR Type selection",
                                         JOptionPane.PLAIN_MESSAGE,
                                         null,
                                         possibilities,
                                         null);

            if(s == possibilities[0]) type = 1;
            else if(s == possibilities[1]) type = 2;
            else {
                JOptionPane.showMessageDialog(null, "No MUR type selected");
                return;
            }
        }

        if(type == 1) {
            String [] barrelLabels = {"Barrel (3-6)", "Row (0-55)", "Position (-1 or 1)"};
            labels = barrelLabels;
        } else {
            String [] endCapLabels = {"Disk (-9 to -1, 1 to 9)", "Quadrant (0-3)", "Position (0-5)"};
            labels = endCapLabels;
        }

        SelectionDialog dia = new SelectionDialog(null, "Edit Physical Mapping", labels, defaults);

        dia.pack();
        dia.setVisible(true);

        try {
            for(int i=0; i<3; i++) {
                System.out.println(labels[i] + ": " + dia.getIntFieldValue(i));
            }

            try {
                if(config.getMURType(mur) == sctConf.MURType.BARREL || type == 1) {
                    config.mapBarrelMUR(mur,
                                        dia.getIntFieldValue(0), dia.getIntFieldValue(1), dia.getIntFieldValue(2));
                    System.out.println("Configured Barrel MUR");
                } else if(config.getMURType(mur) == sctConf.MURType.ENDCAP || type == 2) {
                    config.mapEndcapMUR(mur,
                                        dia.getIntFieldValue(0), dia.getIntFieldValue(1), dia.getIntFieldValue(2));
                    System.out.println("Configured Endcap MUR");
                } else {
                    // No mapping selected?
                }
            } catch(ConfigurationException cex) {
                System.out.println("Failed to mapPhysicalChannel: " + cex);
                return;
            }

            // Physical mapping not shown in normal gui...
            //                        modifyComponetns();
        } catch(SelectionDialog.InvalidDialogException i) {
            JOptionPane.showMessageDialog(null, "Failed to interpret entry(ies)");
        } catch(SelectionDialog.CancelledDialogException i) {
            // Cancel pressed
        }
    }//GEN-LAST:event_physicalMappingPerformed

    String getTitleString() {
        return "MUR " + mur + " position " + getPosition();
    }

    void modifyComponents() {
        channelPanels = new ChannelParamsPanel[6];
        
        int channelBase = order*6;

        for(int i=0; i<6; i++) {
            channelPanels[i] = new GuiComponents.SctConf.ChannelParamsPanel();

            channelPanels[i].setConfig(getConfig());
            channelPanels[i].setPosition(i+1);
            channelPanels[i].setRod(rod);
            channelPanels[i].setMur(mur);
            channelPanels[i].setChannel(channelBase + i);

            if(i<3) {
                chanBox.add(channelPanels[i]);
            } else {
                chanBox2.add(channelPanels[i]);
            }
        }
        
        validate();
    }

    int getPosition() {
        return order;
    }

    static JFileChooser fileChooser;

    { fileChooser = null; }

    static String getFileName() {
        if(fileChooser == null) {
            fileChooser = new JFileChooser();
        }

        if(fileChooser.showDialog(null, "Pick module configuration file") == JFileChooser.APPROVE_OPTION) {
          File file = fileChooser.getSelectedFile();
          return file.toString();
        } else {
          return null;
        }
    }

    public sctConf.Configuration getConfig() {
        return config;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel chanBox;
    private javax.swing.JPanel chanBox2;
    private javax.swing.JButton jButton1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel murBox;
    // End of variables declaration//GEN-END:variables

    private ChannelParamsPanel channelPanels[];
}
