package GuiComponents.SctApi;

import java.awt.BorderLayout;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ScanList extends JPanel {
    JList theList;
    Sct_SctApi.SctApi api;
    Sct_SctApi.Scan[] scans;

    public ScanList(Sct_SctApi.SctApi a, Sct_SctApi.Scan[] s) { 
        api = a; scans = s;

        buildGui();
    }
    
    void buildGui() {
        setLayout(new BorderLayout());

        System.out.println("Found " + scans.length + " scans");

        Object [] myScans = new Object[scans.length];

        for(int si=0; si < scans.length; si++) {
            Sct_SctApi.Scan thisScan = scans[si];

            if(thisScan != null) {
                thisScan.print();

                myScans[si] = "" + si;
            }
        }

        theList = new JList(myScans);
        add(new JScrollPane(theList));

        JPanel buttonPanel = new JPanel();
        
        JButton openButton = new JButton("Open scan");

        openButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                int index = theList.getSelectedIndex();

                if(index < 0) return;

                JFrame frame = new JFrame("Scan View");
                frame.getContentPane().add(new ScanView(api, scans[index]));

                frame.addWindowListener(new WindowAdapter() {
                    public void windowClosing(WindowEvent e) {
                        e.getWindow().dispose();
                    }
                });
                frame.pack();
                frame.setVisible(true);

                ((Window)getTopLevelAncestor()).dispose();
            }
        });

        buttonPanel.add(openButton);
        
        JButton newScan = new JButton("New scan");
        newScan.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                Sct_SctApi.Scan scan = api.createScan();

                scan.configure((short)1, 0.0, 100.0, 10.0);

                scan.setNTrigs(1000);

                scan.getTrigger1().singleL1A();

                JFrame frame = new JFrame("Scan View");
                frame.getContentPane().add(new ScanView(api, scan));

                frame.pack();
                frame.setVisible(true);
                ((Window)getTopLevelAncestor()).dispose();
            }
        });
        buttonPanel.add(newScan);

        add(buttonPanel, BorderLayout.SOUTH);
    }
}
