/*
 * RodDiagnostics.java
 *
 * Created on 07 January 2004, 14:12
 */

package GuiComponents.SctApi;

import java.awt.Window;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.JTableHeader;

import Sct_SctApi.SctApi;

/**
 * Panel for low level ROD diagnostics via memory dumps
 *
 * @author  gallop
 */
public class RodDiagnostics extends JPanel implements java.io.Serializable {
    BlockTableModel bTableModel;

    int partition;
    int crate;
    int rod;
    Sct_SctApi.SctApi api;
    
    /** Make it beanable... */
    public RodDiagnostics() {
        initComponents();
        modifyComponents();
    }

    /** Creates new form RodDiagnostics */
    public RodDiagnostics(int p, int c, int r, Sct_SctApi.SctApi a) {
        partition = p;
        crate = c;
        rod = r;
        api = a;

        initComponents();
        modifyComponents();
    }

    public static void main(String [] args) {
        javax.swing.JFrame f = new javax.swing.JFrame("ROD Diag test");
        
        f.getContentPane().add(new RodDiagnostics());
        f.pack();
        f.setVisible(true);
    }

    
    void modifyComponents() {
        JTableHeader tableHeader = blockTable.getTableHeader();
        tableHeader.setReorderingAllowed(false);
        tableHeader.setResizingAllowed(false);

        int columnWidth = blockTable.getFontMetrics(blockTable.getFont()).stringWidth("mmmmmm");
        
        TableColumn column = null;
        for (int i = 0; i < 18; i++) {
            column = blockTable.getColumnModel().getColumn(i);
            if (i == 17) {
                // The ASCII column at the end
                column.setPreferredWidth(columnWidth * 8);
            } else {
                column.setPreferredWidth(columnWidth);
                column.setMaxWidth(columnWidth);
                column.setMinWidth(columnWidth);
            }
        }

        try {
            linkValueText.setText("" + api.testLinkOutRetrieve(partition, crate, rod));
        } catch(NullPointerException n) {
            linkValueText.setText("0");
        }
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel2 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        jTextField2 = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        jTextField3 = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        jTextField4 = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        jTextField6 = new javax.swing.JTextField();
        jPanel3 = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        addressText = new javax.swing.JTextField();
        jLabel8 = new javax.swing.JLabel();
        readValueText = new javax.swing.JTextField();
        jButton1 = new javax.swing.JButton();
        jLabel9 = new javax.swing.JLabel();
        writeValueText = new javax.swing.JTextField();
        jButton2 = new javax.swing.JButton();
        jLabel10 = new javax.swing.JLabel();
        wordCountText = new javax.swing.JTextField();
        jButton3 = new javax.swing.JButton();
        jLabel6 = new javax.swing.JLabel();
        dspNumberText = new javax.swing.JTextField();
        jButton5 = new javax.swing.JButton();
        jPanel5 = new javax.swing.JPanel();
        currDspLabel = new javax.swing.JLabel();
        jLabel11 = new javax.swing.JLabel();
        currAddressLabel = new javax.swing.JLabel();
        jLabel12 = new javax.swing.JLabel();
        currWordCountLabel = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        blockTable = new javax.swing.JTable();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        linkValueText = new javax.swing.JTextField();
        jButton4 = new javax.swing.JButton();

        setLayout(new java.awt.BorderLayout());

        jPanel2.setLayout(new javax.swing.BoxLayout(jPanel2, javax.swing.BoxLayout.X_AXIS));

        jLabel3.setText("Partition");
        jPanel2.add(jLabel3);

        jTextField2.setEditable(false);
        jTextField2.setText(new Integer(getPartition()).toString());
        jPanel2.add(jTextField2);

        jLabel4.setText("Crate");
        jPanel2.add(jLabel4);

        jTextField3.setEditable(false);
        jTextField3.setText(new Integer(getCrate()).toString());
        jPanel2.add(jTextField3);

        jLabel5.setText("ROD");
        jPanel2.add(jLabel5);

        jTextField4.setEditable(false);
        jTextField4.setText(new Integer(getROD()).toString());
        jPanel2.add(jTextField4);

        jLabel7.setText("Slot");
        jPanel2.add(jLabel7);

        jTextField6.setEditable(false);
        jTextField6.setText(getRODSlot());
        jPanel2.add(jTextField6);

        add(jPanel2, java.awt.BorderLayout.NORTH);

        jPanel3.setLayout(new java.awt.GridBagLayout());

        jPanel4.setLayout(new java.awt.GridBagLayout());

        jLabel2.setText("MDSP Address");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        jPanel4.add(jLabel2, gridBagConstraints);

        addressText.setText("0x80000000");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 0.2;
        jPanel4.add(addressText, gridBagConstraints);

        jLabel8.setText("Read Value");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        jPanel4.add(jLabel8, gridBagConstraints);

        readValueText.setEditable(false);
        readValueText.setText("0x00000001");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel4.add(readValueText, gridBagConstraints);

        jButton1.setText("Read single word");
        jButton1.setEnabled(isRODValid());
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                singleReadActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        jPanel4.add(jButton1, gridBagConstraints);

        jLabel9.setText("Write value");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 2;
        jPanel4.add(jLabel9, gridBagConstraints);

        writeValueText.setText("0x00000000");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel4.add(writeValueText, gridBagConstraints);

        jButton2.setText("Write single word");
        jButton2.setEnabled(isRODValid());
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                singleWriteActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 2;
        jPanel4.add(jButton2, gridBagConstraints);

        jLabel10.setText("Word count");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 3;
        jPanel4.add(jLabel10, gridBagConstraints);

        wordCountText.setColumns(7);
        wordCountText.setText("128");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel4.add(wordCountText, gridBagConstraints);

        jButton3.setText("Read MDSP block");
        jButton3.setEnabled(isRODValid());
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mdspBlockReadActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 3;
        jPanel4.add(jButton3, gridBagConstraints);

        jLabel6.setText("Slave DSP number");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 4;
        jPanel4.add(jLabel6, gridBagConstraints);

        dspNumberText.setText("0");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel4.add(dspNumberText, gridBagConstraints);

        jButton5.setText("Read slave DSP block");
        jButton5.setEnabled(isRODValid());
        jButton5.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                slaveBlockReadActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        jPanel4.add(jButton5, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanel3.add(jPanel4, gridBagConstraints);

        currDspLabel.setText("no data");
        jPanel5.add(currDspLabel);

        jLabel11.setText("Address");
        jPanel5.add(jLabel11);

        currAddressLabel.setText("-");
        jPanel5.add(currAddressLabel);

        jLabel12.setText("Words");
        jPanel5.add(jLabel12);

        currWordCountLabel.setText("0");
        jPanel5.add(currWordCountLabel);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanel3.add(jPanel5, gridBagConstraints);

        blockTable.setFont(new java.awt.Font("Monospaced", 0, 10));
        blockTable.setModel(getBlockTableModel());
        blockTable.setShowHorizontalLines(false);
        blockTable.setShowVerticalLines(false);
        jScrollPane1.setViewportView(blockTable);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel3.add(jScrollPane1, gridBagConstraints);

        add(jPanel3, java.awt.BorderLayout.CENTER);

        jPanel1.setLayout(new javax.swing.BoxLayout(jPanel1, javax.swing.BoxLayout.X_AXIS));

        jPanel1.setOpaque(false);
        jLabel1.setText("Link to front panel");
        jPanel1.add(jLabel1);

        linkValueText.setText("0");
        jPanel1.add(linkValueText);

        jButton4.setText("Set");
        jButton4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                setLinkToFrontPanelPerformed(evt);
            }
        });

        jPanel1.add(jButton4);

        add(jPanel1, java.awt.BorderLayout.SOUTH);

    }//GEN-END:initComponents

    private void slaveBlockReadActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_slaveBlockReadActionPerformed
        int address = Long.decode(addressText.getText()).intValue();
        int wordCount = Long.decode(wordCountText.getText()).intValue();
        int dspNumber = Long.decode(dspNumberText.getText()).intValue();

        int [] blockData; 
        
        if(api == null) {
            int [] data = {0, 1, 2, 3, 4, 5, 6, 7, 8};
            blockData = data;
        } else {
            blockData = api.dspBlockRead(partition, crate, rod, address, wordCount, dspNumber);
        }
        bTableModel.newData(blockData);
        currDspLabel.setText("Slave DSP " + dspNumber);
        currAddressLabel.setText("0x" + Integer.toHexString(address));
        currWordCountLabel.setText("" + wordCount);
    }//GEN-LAST:event_slaveBlockReadActionPerformed

    private void setLinkToFrontPanelPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_setLinkToFrontPanelPerformed
        int link = Long.decode(linkValueText.getText()).intValue();

        api.testLinkOutSelect(partition, crate, rod, link);
    }//GEN-LAST:event_setLinkToFrontPanelPerformed

    private void mdspBlockReadActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mdspBlockReadActionPerformed
        int address = Long.decode(addressText.getText()).intValue();
        int wordCount = Long.decode(wordCountText.getText()).intValue();

        int [] blockData; 
        
        if(api == null) {
            int [] data = {0, 1, 2, 3, 4, 5, 6, 7, 8};
            blockData = data;
        } else {
            blockData = api.dspBlockRead(partition, crate, rod, address, wordCount, -1);
        }
        bTableModel.newData(blockData);
        currDspLabel.setText("Master DSP");
        currAddressLabel.setText("0x" + Integer.toHexString(address));
        currWordCountLabel.setText("" + wordCount);
    }//GEN-LAST:event_mdspBlockReadActionPerformed

    private void singleWriteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_singleWriteActionPerformed
        int address = Long.decode(addressText.getText()).intValue();
        int value = Long.decode(writeValueText.getText()).intValue();
        api.dspSingleWrite(partition, crate, rod, address, value, -1);
    }//GEN-LAST:event_singleWriteActionPerformed

    private void singleReadActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_singleReadActionPerformed
        int address = Long.decode(addressText.getText()).intValue();
        readValueText.setText("0x" + Long.toHexString(api.dspSingleRead(partition, crate, rod, address, -1)));
    }//GEN-LAST:event_singleReadActionPerformed

    public TableModel getBlockTableModel() {
        if(bTableModel == null) {
            int [] nullBlock = {};

            bTableModel = new RodDiagnostics.BlockTableModel(nullBlock);
        }

        return bTableModel;
    }    
    
    public int getPartition() {
        return partition;
    }

    public int getCrate() {
        return crate;
    }

    public int getROD() {
        return rod;
    }

    public String getRODSlot() {
        try {
            long rodSlot = api.getRodSlot(partition, crate, rod);
            return "" + rodSlot;
        } catch(NullPointerException n) {
            return "No API";
        }
    }

    public boolean isRODValid() {
        if(api == null) {
            if(getTopLevelAncestor() == null) {
                // Doesn't have an ancestor when its being constructed...
                return false;
            } else {
                ((Window)getTopLevelAncestor()).dispose();
                return false;
            }
        } else {
            return api.isRODPresent(partition, crate, rod);
        }
    }

    /** Setter for property partition.
     * @param partition New value of property partition.
     *
     */
    public void setPartition(int partition) { this.partition = partition; }
    
    public class BlockTableModel extends javax.swing.table.AbstractTableModel {
        int [] blockArray;

        public BlockTableModel(int [] block) {
            blockArray = block;
        }

        public void newData(int [] block) {
            blockArray = block;
            fireTableDataChanged();
        }
        
        public int getColumnCount() {
            // 16 + address + ascii version
            return 16+2;
        }

        public int getRowCount() {
            return (blockArray.length+7) / 8;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
/*            System.out.println("r" + rowIndex + ", c" + columnIndex);
            System.out.println(" offset " + (rowIndex*8 + columnIndex) + " len " + blockArray.length);
*/
            if(columnIndex == 0) {
                return Integer.toHexString(rowIndex*32);
            } else if(columnIndex == 17) {
                StringBuffer buff = new StringBuffer();
                
                int offset = rowIndex*8;

                for(int i=0; i<8; i++) {
                    if(offset + i >= blockArray.length) {
                        break;
                    }

                    for(int j=0; j<4; j++) {
                        int ascii = (blockArray[offset + i] >> (8*j)) & 0xff;
                        if(ascii >= 32 && ascii < 128) {
                            buff.append((char)ascii);
                        } else {
                            buff.append(".");
                        }
                    }

                    buff.append(" ");
                }
                return buff.toString();
            } else {
                columnIndex --;
                if((columnIndex/2) + rowIndex*8 >= blockArray.length) {
                    return null;
                } else {
                    int value = blockArray[(columnIndex/2) + rowIndex*8];
                    String hexString = Integer.toHexString(value);
                    if(columnIndex % 2 == 0) {
                        if(hexString.length() > 4) {
                            hexString = hexString.substring(0, hexString.length()-4);
                        } else {
                            hexString = "0000";
                        }
                    } else {
                        if(hexString.length() > 4) {
                            hexString = hexString.substring(hexString.length()-4);
                        } else {
                            // Leave it
                        }
                    }
                    return "0000".substring(0, 4-hexString.length()) + hexString; 
                }
            }
        }
        
        public String getColumnName(int columnIndex) {
            String retValue;
            
            if(columnIndex == 0) {
                retValue = "";
            } else if(columnIndex == 17) {
                retValue = "ASCII";
            } else {
                columnIndex--;
                retValue = Integer.toHexString((columnIndex * 2));
            }

            return retValue;
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField addressText;
    private javax.swing.JTable blockTable;
    private javax.swing.JLabel currAddressLabel;
    private javax.swing.JLabel currDspLabel;
    private javax.swing.JLabel currWordCountLabel;
    private javax.swing.JTextField dspNumberText;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JButton jButton4;
    private javax.swing.JButton jButton5;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextField jTextField2;
    private javax.swing.JTextField jTextField3;
    private javax.swing.JTextField jTextField4;
    private javax.swing.JTextField jTextField6;
    private javax.swing.JTextField linkValueText;
    private javax.swing.JTextField readValueText;
    private javax.swing.JTextField wordCountText;
    private javax.swing.JTextField writeValueText;
    // End of variables declaration//GEN-END:variables
    
}
