/*
 * ExternalProcess.java
 *
 * Created on 02 May 2003, 13:24
 */

package GuiComponents.Console;

import javax.swing.*;
import java.awt.event.*;
import java.awt.GridBagConstraints;
import java.io.*;

/**
 * A simple frame that displays the output of an external process.
 * @author  Matthew Palmer
 */
public class ExternalProcess extends javax.swing.JFrame implements ActionListener {
    
    protected JConsole console;
    protected Process process;
    private StreamThread stdout;
    private StreamThread stderr;
    private Writer stdin;
    
    /** Creates new form ExternalProcess */
    public ExternalProcess(String cmd) throws IOException{        
        initComponents();
        myInit(cmd);
        setTitle(cmd);
        setSize(800,500);
        show();
    }
    
    private void myInit(String cmd) throws IOException{
        console = new JConsole();
        console.addActionListener(this);
        GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);     
        gridBagConstraints.fill = GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1;
        gridBagConstraints.weighty = 1;
        getContentPane().add(new JScrollPane(console), gridBagConstraints);
                
        process = Runtime.getRuntime().exec(cmd);
        stdout = new StreamThread(process.getInputStream());
        stderr = new StreamThread(process.getErrorStream());
        stdin = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
        stdout.start();
        stderr.start();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;
        
        bClose = new javax.swing.JButton();
        
        getContentPane().setLayout(new java.awt.GridBagLayout());
        
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });
        
        bClose.setText("Close");
        bClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bCloseActionPerformed(evt);
            }
        });
        
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(bClose, gridBagConstraints);
        
        pack();
    }//GEN-END:initComponents

    private void bCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bCloseActionPerformed
        close();
    }//GEN-LAST:event_bCloseActionPerformed
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        close();
    }//GEN-LAST:event_exitForm

    
    public void close() {        
        process.destroy();
        stdout.stop = true;
        stderr.stop = true;
        this.dispose();
    }
    
    /** Invoked when an action occurs.
     *  Pass the string onto the app
     */
    public void actionPerformed(ActionEvent e) {
        String line = e.getActionCommand();
        try {
            System.out.println("Writing: " + line);
            stdin.write(line);
            System.out.println("Done");
        } catch (IOException ioe) {            
        }
    }
    
    class StreamThread extends Thread {
	InputStream inputStream;
        volatile boolean stop = false;

	StreamThread(InputStream inputStream) {
            this.inputStream = inputStream;
	} 
		
	public void run() {
            try	{
		BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));

                StringBuffer line = new StringBuffer(2000);  
                String temp;
                int nLines;
                while (!stop) {
                    line.setLength(0);                    
                                        
                    for (nLines = 0; in.ready() && nLines < 100; ++nLines) {                         
                        line.append(in.readLine()).append("\n");
                    }
                    //System.out.println(nLines);
                    if (nLines == 0) {
                        temp = in.readLine();
                        if (temp == null) break;
                        line.append(temp).append("\n");
                    }
                    
                    if (console != null) {
                        console.print(line.toString());
                    } 
                    try {
                        sleep(100);
                    } catch (java.lang.InterruptedException e){}
                }
                
		in.close();
            }
            catch(Exception e) {
                if(console != null) console.println(e.getMessage());
                else System.out.println(e.getMessage());
            } 
	} 
    } 
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton bClose;
    // End of variables declaration//GEN-END:variables
    
}
