#include "SctFitter/FitStrategy.h"
#include "Sct/Exception.h"
#include "SctData/GausFitObject.h"
#include <owl/timer.h>
#include <TH1.h>
#include <TCanvas.h>
#include <TF1.h>
#include <TFile.h>
#include <TMath.h>

int main(int argc, char**argv){
    Sct::setExceptionHandlers(argv[0]);
    using namespace std;

    if (argc<2){
	cout << "Usage: TestFitStrategy <strategyName> [options]" << endl; 
	return -1;
    }
    SctFitter::FitStrategy* strategy;
    try{
	strategy = SctFitter::FitStrategyFactory::instance().getStrategy(string(argv[1]));
	cout << "Strategy = " << strategy->getName() << endl;
    }
    catch (Sct::LogicError &e){
	cout << "Error " << e.what() << endl;
	return -1;
    }
    
    if (argc>=3){
	strategy->setOptions(string(argv[2]));
    }

    TFile f("h.root","READ"); 
    TH1D* h = static_cast<TH1D*> ( f.Get("hist") );
    
    if (!h) {
	cerr << "No histogram" <<endl; return -1;
    }

    SctData::GausFitObject g;
    cout << "Made FitObject"<<endl;
    
    g.setParameter(0,100.);
    g.setParameter(1,0.);
    g.setParameter(2,1.);
    g.setVarMin(0,-3.);
    g.setVarMax(0,3.);

    cout << "Set up FitObject"<<endl;
    
    OWLTimer timer;

    for (int i=0; i<h->GetNbinsX(); ++i){
	double err=TMath::Sqrt(h->GetBinContent(i+1));
	if (err<1.) err=1.;
	h->SetBinError(i+1, err);
    }
    
    timer.start();
    const int NFITS=1000;

    try{
	for (int i=0; i<NFITS; ++i){
	    auto_ptr<TF1> f (g.makeRootTF1());
	    
	    strategy->fitTH1(*h, *f);
	    //h->Fit(f, strategy->getOptions().c_str());
	    if (i==(NFITS-1)){
		timer.stop();
		f->Print();
		g=*f;
		cout <<endl<<g<<endl;
		cout << "Time (U,T,S) =" << timer.userTime() 
		     << ", " << timer.totalTime()
		     << ", " << timer.systemTime() << endl;
	    }
	}
    }

    catch(Exception &e){
	cout << e.what() << endl;
	return -1;
    }

    f.Close();
    return 0;
}
