#ifndef STROBEDELAYTEST_H
#define STROBEDELAYTEST_H

#include "../ipc/TestRequest.h"
#include "../ipc/CalibrationController.h"
#include "../ipc/ScanLibrary.h"
#include "../ipc/Sct_CalibrationController.hh"

#include "../SctApiAccessException.h"
#include "Sct/LogicErrors.h"
#include "../SctApiCall.h"

#include <CommonWithDsp/ABCD/ABCDscans.h>
#include <iostream>
#include <vector>

using namespace Sct;
using namespace std;
using namespace SctCalibrationController::Ipc;
using namespace SctCalibrationController;

namespace SctCalibrationController {
namespace Scripts {
    
class StrobeDelayTest : public TestRequestImpl {
public:	
    static StrobeDelayTest& instance() {
	static StrobeDelayTest rc;
	return rc;
    }
    
    virtual void startTest(Sct_SctApi_T_SctApi& api, string& name, unsigned short& testVariable, unsigned long& nScans, vector<double>& testPoints) {	
	this->api = &api;

        // Compression mode 2
        APICALL(&api, modifyABCDVar(&st, ST_COMPRESSION, 2), "StrobeDelayTest::startTest")

        // Edge detect on
        APICALL(&api, modifyABCDVar(&st, ST_EDGE_DETECT, 1), "StrobeDelayTest::startTest")

        // No masked channels
        APICALL(&api, modifyABCDVar(&st, ST_SEND_MASK, 0), "StrobeDelayTest::startTest")

        // Set threshold to 2fC (based on previous configuration)
        APICALL(&api, modifyABCDVar(&st, ST_QTHR, 2), "StrobeDelayTest::startTest")

        // 4.00 fC input charge
        APICALL(&api, modifyABCDVar(&st, ST_VCAL, 40), "StrobeDelayTest::startTest")

	name = "StrobeDelayTest";
	testVariable = ST_ELAPSED;
	nScans = 1;

	testPoints.push_back(0);
    }
    
    virtual ScanRequest* getNextScan(unsigned long index) {
	ScanLibrary& sl = CalibrationControllerImpl::instance().getScanLibrary();
	return &sl.strobeDelayScan(1000);		
    }
    
    virtual bool canFeedback() {
	return true;
    }    
    
    virtual void endTest() {
	api = 0;
    }
    
private:
    StrobeDelayTest() {}
    Sct_SctApi_T_SctApi* api;    
};
}
}
#endif //STROBEDELAYTEST_H
