#ifndef NOISEOCCUPANCYSCAN_H
#define NOISEOCCUPANCYSCAN_H

#include <cmath>  // For fabs

#include "../ipc/Sct_CalibrationController.hh"
#include "../CalibrationControllerImpl.h"
#include "../ipc/ScanRequest.h"
#include "../SctApiAccessException.h"
#include "../SctApiCall.h"
#include "Sct/LogicErrors.h"

#include <CommonWithDsp/ABCD/ABCDscans.h>

using namespace Sct;
using namespace SctCalibrationController::Ipc;
namespace SctCalibrationController {
namespace Scripts {

class NoiseOccupancyScan  : public ScanRequestImpl {
public:
    static ScanRequestImpl& noiseOccupancyScan() {
      static NoiseOccupancyScan request;
      Sct_SctApi_T_SctApi* api = CalibrationControllerImpl::instance().getApi();
      Sct_SctApi_T_Scan* s = 0;
      APIRETCALL(api, s, createScan(&st), "Failed to create scan")

	request.setScan(s);

        APICALL(s, setNTrigs(&st, 1000), "Failed to set triggers")
	
        Sct_SctApi_T_Trigger* t = 0;
      APIRETCALL(s, t, getTrigger1(&st), "Failed to get Trigger1")
	
        APICALL(t, calL1A(&st, 0x82), "Failed to set trigger type")

        APICALL(s, configure(&st, ST_TTHR, 20, -80, -5), "Failed to set Scan information")

	// Too slow to do 1e6 triggers (almost 10mins for these on two modules)
/*         APICALL(s, setVariableTrigRange(&st, 0, 4, 1000000), "Failed to set trigger count"); */
        APICALL(s, setVariableTrigRange(&st, 0, 8, 100000), "Failed to set trigger count");
        APICALL(s, setVariableTrigRange(&st, 9, 11, 10000), "Failed to set trigger count");
        APICALL(s, setVariableTrigRange(&st, 12, 20, 1000), "Failed to set trigger count");

	return request;
    }
    
private:
    NoiseOccupancyScan(){;}	
};
    
}
}

#endif //THRESHOLDSCAN_H
