#ifndef FULLBYPASSENDCAPTEST_H
#define FULLBYPASSENDCAPTEST_H

#include "../ipc/TestRequest.h"
#include "../ipc/CalibrationController.h"
#include "../ipc/ScanLibrary.h"
#include "../ipc/Sct_CalibrationController.hh"

#include "../SctApiAccessException.h"
#include "../SctApiCall.h"
#include "Sct/LogicErrors.h"

#include <CommonWithDsp/ABCD/ABCDscans.h>
#include <iostream>
#include <vector>

using namespace Sct;
using namespace std;
using namespace SctCalibrationController::Ipc;
using namespace SctCalibrationController;

namespace SctCalibrationController {
namespace Scripts {

class FullBypassEndcapTest : public TestRequestImpl {
public:
    static FullBypassEndcapTest& instance() {
	static FullBypassEndcapTest fb;
	return fb;
    }

    virtual void startTest(Sct_SctApi_T_SctApi& api, string& name, unsigned short& testVariable, unsigned long& nScans, vector<double>& testPoints) {
	this->api = &api;

        // Compression mode X1X
        APICALL(&api, modifyABCDVar(&st, ST_COMPRESSION, 1), "FullBypassEndcapTest::startTest")

        // Edge detect off
        APICALL(&api, modifyABCDVar(&st, ST_EDGE_DETECT, 0), "FullBypassEndcapTest::startTest")

        // No masked channels
        APICALL(&api, modifyABCDVar(&st, ST_MASK, 3), "FullBypassEndcapTest::startTest")

        // Route mask to pipeline
        APICALL(&api, modifyABCDVar(&st, ST_SEND_MASK, 1), "FullBypassEndcapTest::startTest")

	name = "FullBypassTest";
	testVariable = ST_ELAPSED;	// Actually vary Vdd, but no variable for that

	/*for (unsigned i=0; i<6; ++i){
	    vdd.push_back(4.0 - 0.1*i);    // 6 scan points, 4.0 -> 3.5 in 0.1 steps.
	}*/

        vdd.clear();
	vdd.push_back(4.0);

	testPoints = vdd;
	nScans = testPoints.size();
    }

    /**
      Just do a token scan for now.  Don't change Vdd as it doesn't work
    */
    virtual ScanRequest* getNextScan(unsigned long index) {
	if (api == 0)
	    throw InvariantViolatedError("Api pointer is 0 in getNextScan!", __FILE__, __LINE__);

	//Sct_SctApiStatus status;
	//api->modifyABCDVar(&status, 33, vdd[index]);   // set the digital voltage.
	//if (status.returnCode != 0)
	//    throw SctApiAccessException(status.returnCode, "FullBypassTest::getNextScan", __FILE__, __LINE__);

	ScanLibrary& sl = CalibrationControllerImpl::instance().getScanLibrary();
	ScanRequest& srequest = sl.tokenScan();
	
	Sct_SctApi_T_Scan* scan = srequest.getScan();
	if (scan) {
	  APICALL(scan, configure(&st, ST_TOKEN, 0, 61, 1), "Failed to set Scan information") ;
	}
	return &srequest;
    }
    
    virtual bool canFeedback() {
	return false;
    }    
    
    virtual void endTest() {
	if (api == 0) 
	    throw InvariantViolatedError("Api pointer is 0 in endTest!", __FILE__, __LINE__);
	
/*	Sct_SctApiStatus status;
	api->modifyABCDVar(&status, 33, 4.0);  // set the digital voltage to 4
	if (status.returnCode != 0)
	    throw SctApiAccessException(status.returnCode, "FullBypassTest::endTest", __FILE__, __LINE__);
	
	api->modifyABCDVar(&status, ST_BYPASS, 4);    // 12 chips through 2 links.
	if (status.returnCode != 0)
	    throw SctApiAccessException(status.returnCode, "FullBypassTest::endTest", __FILE__, __LINE__);
*/	
	api = 0;
    }

private:
    FullBypassEndcapTest() {}
    Sct_SctApi_T_SctApi* api;    
    std::vector<double> vdd;
};
}
}
#endif //FULLBYPASSTEST_H
