#ifndef CHARACTERIZATIONSEQUENCE_H
#define CHARACTERIZATIONSEQUENCE_H

#include "../ipc/SequenceRequest.h"
#include "../ipc/TestRequest.h"
#include "../ipc/CalibrationController.h"
#include "../ipc/TestLibrary.h"
#include "../ipc/Sct_CalibrationController.hh"
#include <iostream>

using namespace std;

namespace SctCalibrationController {
    
using namespace Ipc;

namespace Scripts {
    
class CharacterizationSequence : public SequenceRequestImpl {
public:	
    static CharacterizationSequence& instance() {
	static CharacterizationSequence cs;
	return cs;
    }
    
    virtual string startSequence(Sct_SctApi_T_SctApi& api) {
	this->api = &api;
	return "CharacterizationSequence";
    }
    
    virtual TestRequest* getNextTest(unsigned long index) {
	TestLibrary& tl = CalibrationControllerImpl::instance().getTestLibrary();
	switch (index) {
	case 0:
	    return &tl.nmask();
	case 1:
#warning Only Barrel combinations of bypass included in characterization sequence
	    return &tl.fullBypassBarrel();	    
	case 2:
	    return &tl.pipeline();
	case 3:
	    return &tl.strobeDelay();
	case 4:
	    return &tl.threePointGain();
        case 5:
            return &tl.trimRange();
	case 6:
	    return &tl.responseCurve();
	case 7:
	    return &tl.noiseOccupancy();
	case 8:
	    return &tl.timeWalk();
	default:
	    return 0;
	}
    }
    
    virtual void endSequence() {
	api = 0;
    }     
    
private:
    Sct_SctApi_T_SctApi* api;
    CharacterizationSequence() {}
};
}
}
#endif //CHARACTERIZATIONSEQUENCE_H
