#ifndef TESTLIBRARY_H
#define TESTLIBRARY_H

#include "Sct_CalibrationController.hh"
#include <boost/utility.hpp>
#include <ipc/object.h>

namespace SctCalibrationController {
namespace Ipc {

class TestRequestImpl;

class TestLibrary : public IPCCallback, public virtual Sct_CalibrationController_T_TestLibrary, boost::noncopyable {
public:
    Sct_CalibrationController_T_TestRequest * responseCurve (Sct_CalibrationControllerStatus *_status);
    Sct_CalibrationController_T_TestRequest * threePointGain (Sct_CalibrationControllerStatus *_status);
    Sct_CalibrationController_T_TestRequest * strobeDelay (Sct_CalibrationControllerStatus *_status);
    Sct_CalibrationController_T_TestRequest * noiseOccupancy (Sct_CalibrationControllerStatus *_status);
    Sct_CalibrationController_T_TestRequest * pipeline (Sct_CalibrationControllerStatus *_status);
    Sct_CalibrationController_T_TestRequest * fullBypassBarrel (Sct_CalibrationControllerStatus *_status);
    Sct_CalibrationController_T_TestRequest * fullBypassEndcap (Sct_CalibrationControllerStatus *_status);
    Sct_CalibrationController_T_TestRequest * trimRange (Sct_CalibrationControllerStatus *_status);
    Sct_CalibrationController_T_TestRequest * timeWalk (Sct_CalibrationControllerStatus *_status);
    Sct_CalibrationController_T_TestRequest * nmask (Sct_CalibrationControllerStatus *_status);
    
    Sct_CalibrationController_T_TestRequest * rxDelay (Sct_CalibrationControllerStatus *_status);
    Sct_CalibrationController_T_TestRequest * rxThreshold (Sct_CalibrationControllerStatus *_status);
    
    virtual TestRequestImpl& responseCurve() const = 0;
    virtual TestRequestImpl& threePointGain() const = 0;
    virtual TestRequestImpl& strobeDelay() const = 0;   
    virtual TestRequestImpl& noiseOccupancy() const = 0; 
    virtual TestRequestImpl& pipeline() const = 0;
    virtual TestRequestImpl& fullBypassBarrel() const = 0;
    virtual TestRequestImpl& fullBypassEndcap() const = 0;
    virtual TestRequestImpl& trimRange() const = 0;   
    virtual TestRequestImpl& timeWalk() const = 0;
    virtual TestRequestImpl& nmask() const = 0;
    
    virtual TestRequestImpl& rxDelay() const = 0;
    virtual TestRequestImpl& rxThreshold() const = 0;
protected:
    TestLibrary();
};
}    
}

#endif //TESTLIBRARY_H
