#ifndef SCANLIBRARY_H
#define SCANLIBRARY_H

#include "Sct_CalibrationController.hh"
#include "ScanRequest.h"
#include <boost/utility.hpp>
#include <ipc/object.h>

namespace SctCalibrationController {
namespace Ipc {
    
class ScanLibrary : public IPCCallback, public virtual Sct_CalibrationController_T_ScanLibrary, boost::noncopyable {
public:
  virtual Sct_CalibrationController_T_ScanRequest * thresholdScan (Sct_CalibrationControllerStatus *_status, ilu_Cardinal nTrigs);
  virtual Sct_CalibrationController_T_ScanRequest * thresholdScanfC (Sct_CalibrationControllerStatus *_status, ilu_Cardinal nTrigs, ilu_Real calCharge);
  virtual Sct_CalibrationController_T_ScanRequest * noiseOccupancyScan (Sct_CalibrationControllerStatus *_status);
  virtual Sct_CalibrationController_T_ScanRequest * strobeDelayScan (Sct_CalibrationControllerStatus *_status, ilu_Cardinal nTrigs);
  virtual Sct_CalibrationController_T_ScanRequest * nmaskScan (Sct_CalibrationControllerStatus *_status, ilu_Cardinal nTrigs);
  virtual Sct_CalibrationController_T_ScanRequest * tokenScan (Sct_CalibrationControllerStatus *_status);
  
  virtual Sct_CalibrationController_T_ScanRequest * defaultScan (Sct_CalibrationControllerStatus *_status);

  virtual Sct_CalibrationController_T_ScanRequest * rawScan (Sct_CalibrationControllerStatus *_status, unsigned long nTrigs);

  virtual ScanRequestImpl& thresholdScan(unsigned long nTrigs) const = 0;
  virtual ScanRequestImpl& thresholdScanfC(unsigned long nTrigs, double calCharge) const = 0;    
  virtual ScanRequestImpl& thresholdScanfCOffset(unsigned long nTrigs, double calCharge, double offset) const = 0;
  virtual ScanRequestImpl& noiseOccupancyScan() const = 0;
  virtual ScanRequestImpl& strobeDelayScan(unsigned long nTrigs) const = 0;
  virtual ScanRequestImpl& nmaskScan(unsigned long nTrigs) const = 0;    
  virtual ScanRequestImpl& tokenScan() const = 0;
  virtual ScanRequestImpl& defaultScan() const = 0;
  virtual ScanRequestImpl& rawScan(unsigned long nTrigs) const = 0;
protected:
    ScanLibrary();
};    
}
}
#endif //SCANLIBRARY_H
