#ifndef SEQUENCEMAP_H
#define SEQUENCEMAP_H

#include <boost/utility.hpp>
#include <boost/weak_ptr.hpp>
#include <boost/shared_ptr.hpp>
#include <ctime>
#include <map>
#include <string>

using namespace std;
using boost::weak_ptr;
using boost::shared_ptr;

namespace SctCalibrationController {
    
class Sequence;

class SequenceMap : boost::noncopyable {
public:    
    static SequenceMap& instance() throw();
    
    weak_ptr<Sequence> getSequence(const string& name) throw();
    void addSequence(shared_ptr<Sequence> sequence) throw();
    
private:
    SequenceMap() throw();
    
    struct SequenceMapData {
	SequenceMapData() throw();
	shared_ptr<Sequence>  sequence;
	time_t created;
	time_t lastRequested;
    };
    typedef map<string, SequenceMapData> DataMap;
    
    DataMap map;
    
    void purge() throw();
    void remove(DataMap::iterator& i) throw();
};

}

#endif //SEQUENCEMAP_H
