#include "IsPutCommand.h"
#include "Archiver.h"
#include "SerializableWrappers.h"
#include "Sct/IS/IOManagerIS.h"
#include "Sct/LogicErrors.h"
#include "Sct/IoExceptions.h"
#include "Sct/ISProxy/IOManagerISProxy.h"
// Summary stuff:
#include "SummaryWriter/TestSummaryIS.h"
#include "SummaryWriter/SummaryManager.h"
#include "SctData/TestResult.h"

#include "is/isinfoany.h"

#include <boost/timer.hpp>
#include <sstream>

namespace SctArchiving{
  IsPutCommand::IsPutCommand(boost::shared_ptr<Sct::Serializable> ob)
    : PutCommand(ob)  {
  }

  IsPutCommand::IsPutCommand() {}

  IsPutCommand::~IsPutCommand() {}

  void IsPutCommand::setServer(const string& name){
    m_server=name;
  }

  boost::shared_ptr<ArchivingCommand> IsPutCommand::create()const{
    boost::shared_ptr<ArchivingCommand> cmd(new IsPutCommand() );
    return cmd;
  }
  
  void IsPutCommand::execute(){
    boost::timer t;

    if (!m_ob.get()) throw Sct::IllegalStateError("Null pointer", __FILE__, __LINE__);
    if (m_server=="") m_server = Archiver::instance().getRetrieveIsServer();

    if (m_ob->getClassName()=="TestData" || m_ob->getClassName()=="SequenceData") {
      shared_ptr<Sct::ISSerializableWrapperI> wrap = boost::dynamic_pointer_cast<Sct::ISSerializableWrapperI>(m_ob);
      if (!wrap.get()) throw Sct::IllegalStateError(m_ob->getClassName() + 
						    " couldnt be cast as a ISSerializableWrapperI", __FILE__, __LINE__);
      wrap->publishWrappedObjectToServer( m_server );
    }else{
      Sct::IS::IOParamsIS params( m_server );
      Sct::ISProxy::IOManagerISProxy::instance().write(*m_ob, &params);      
    }

     // if TestResult publish summary too.
    if (m_ob->getClassName().find("TestResult")!=std::string::npos){
      try{
	shared_ptr<SctData::TestResult> r = boost::dynamic_pointer_cast<SctData::TestResult>(m_ob);
	TestSummaryIS t;
	t.dataString = SctData::TestSummary::SummaryManager::instance().write(*r);
	std::string name = m_server;
	name += ".";
	name += "Summary.";
	name += m_ob->getUniqueID();
	ISInfoDictionary& is = SctNames::getISDictionary();
	ISInfo::Status stat;
	if (is.contains(name.c_str())) {
	  stat = is.update(name.c_str(), t);
	} else {
	  stat = is.insert(name.c_str(), t);
	}
      }catch(Sct::Throwable& e){
	e.sendToMrs(MRS_DIAGNOSTIC);
      }
      
      Archiver::instance().addISTime(t.elapsed());
    }
  }
}
