#include "StrobeDelayAlgorithm.h"
#include "AnalysisAlgorithmMap.h"
#include "SctData/StrobeDelayTestResult.h"
#include "SctData/FitScanResult.h"
#include "SctData/FitObject.h"
#include "SctData/TopHatFitObject.h"
#include "SctData/DefectList.h"
#include "SctData/StandardDefects.h"
#include <string>

using namespace std;
using namespace boost;
using namespace SctData;
using namespace Sct;

namespace SctAnalysis {
    
bool StrobeDelayAlgorithm::inMap = AnalysisAlgorithmMap::instance().setAlgorithm("StrobeDelayTest", auto_ptr<AnalysisAlgorithm>(new StrobeDelayAlgorithm()));

shared_ptr<AnalysisAlgorithm> StrobeDelayAlgorithm::clone(const TestData& testData, const string& moduleName) const throw(){
    return shared_ptr<AnalysisAlgorithm>(new StrobeDelayAlgorithm(testData, moduleName, *this));
}

shared_ptr<TestResult> StrobeDelayAlgorithm::createTestResult() const {
    return shared_ptr<StrobeDelayTestResult> (new StrobeDelayTestResult()) ;
}

void StrobeDelayAlgorithm::loadData() {
    loadAllFits();
}

bool StrobeDelayAlgorithm::canAnalyze() const {
    return hasAllFits();
}

void StrobeDelayAlgorithm::analyze() {
    const double fraction=0.25;
	
    StrobeDelayTestResult& result = *dynamic_pointer_cast<StrobeDelayTestResult>(getTestResult());
    const FitScanResult& fitted = *getFit(0);
    result.setScanVariable(fitted.getHeader().getVariable());	

    bool pass = true;
    result.setNOptima(nChipModule);
    for (short unsigned int ichip=0; ichip<nChipModule; ++ichip ) {
      const DefectSeverity& severity = result.getDefects().defectSeverityAffectingElement(ModuleElement::Chip(ichip));
      if (severity>=SERIOUS) pass=false;
      FitObject& fit = fitted.getChipFit(ichip);
      try {
	dynamic_cast<TopHatFitObject&> (fit);
      } catch(std::exception& e) {
	throw InvariantViolatedError("StrobeDelayAlgorithm::optimize ERROR not a TopHat function", __FILE__, __LINE__);
      }
      double rise=fit.getParameter(1), fall=fit.getParameter(3);
      result.setOptimum(ichip, rise + fraction*(fall-rise));
      if (rise < 0 || fall < StandardDefects::SD_LO.getParameter()) {
	result.getDefects().addDefect(Defect(StandardDefects::SD_LO, ModuleElement::Chip(ichip)));
	pass = false;
      } 
      if (rise > StandardDefects::SD_HI.getParameter() || fall > 63) {
	result.getDefects().addDefect(Defect(StandardDefects::SD_HI, ModuleElement::Chip(ichip)));
	pass = false;
      }
    }
    result.setPassed(pass);
}


}
