package ProdDatabase;
// getDBfiles.java
// @Author Dave Robinson
//
// 21052003 Introduce controlFlag - bit 1 set means create upload files but don't upload
//                                  bit 2 set means don't show gui and immediately create upload files


import java.io.*;
import java.util.Vector;
import java.util.regex.*;

public class getDBfiles {

        static String outputDirectory;
	static java.util.Map serialNoMap = null;
	static boolean dontOverwrite = false;
	static String firstSerialNo="";
	static String lastSerialNo="";
	static String testLocation="Anywhere";
	static String runNo=null;
	static String scanNo=null;
	static int temperature=0;
	static int testType=-1;
	static int testRequest=-1;
	
	public static void main(String[] args) {
          Pattern serialNoPattern = Pattern.compile("(\\d{14})");
          Pattern testRequestPattern = Pattern.compile("-(\\d{1,2})");
           Matcher matcher;
                if(args.length<2) showOptions("Syntax is java ProdDatabase/getDBfiles followed by: ");
                        
                outputDirectory=null;
                boolean nextArgIsTestLocation = false;
                boolean nextArgIsOutputDirectory=false;
                boolean nextArgIsRunNo=false;
                boolean nextArgIsScanNo=false;		

                for(int i=0;i<args.length;i++) {
                  if(nextArgIsTestLocation) {
                      testLocation = args[i];
                      try {
                                   if(!GeneralUtilities.confirmLocation(testLocation)) {
                                      System.out.println("** Test location '"+testLocation+"' not recognised. Spelling? (Case-sensitive)");
                                      System.exit(0);
                                      }
                      } catch(Exception ee) {System.out.println("Failed to connect to database."); System.exit(0);}
                      nextArgIsTestLocation=false;
                      continue;
                      }
                  if(nextArgIsOutputDirectory) {
                      outputDirectory = args[i];
                      nextArgIsOutputDirectory=false;
                      File temp = new File(outputDirectory);
                      if(!temp.exists()) {
                        System.out.println("** Directory "+outputDirectory+" does not exist!");
                        System.exit(0);
                        }
                      continue;
                      }
                  if(nextArgIsRunNo) {
                      nextArgIsRunNo=false;
                      runNo = args[i];
                      continue;
                      }
                  if(nextArgIsScanNo) {
                      nextArgIsScanNo=false;
                      scanNo = args[i];
                      continue;
                      }
                  if(args[i].equals("-iv") || args[i].equals("-IV")) {
                        testType=SCTDBInfo.SCTDB_TEST_IV;
                        continue;
                        }
                  if(args[i].equals("-rc") || args[i].equals("-RC")) {
                        testType=SCTDBInfo.SCTDB_TEST_NPTGAIN;
                        continue;
                        }
                  if(args[i].equals("-xml") || args[i].equals("-XML")) {
                        testType=SCTDBInfo.SCTDB_TEST_TIMEWALK;
                        continue;
                        }
                  if(args[i].equals("-trim") || args[i].equals("-TRIM")) {
                        testType=SCTDBInfo.SCTDB_TEST_TRIM;
                        continue;
                        }
                  if(args[i].equals("-3ptgain") || args[i].equals("-3PTGAIN")) {
                        testType=SCTDBInfo.SCTDB_TEST_3PTGAIN;
                        continue;
                        }
                  if(args[i].equals("-warm") || args[i].equals("-WARM")) {
                        temperature=2;
                        continue;
                        }
                  if(args[i].equals("-cold") || args[i].equals("-COLD")) {
                        temperature=1;
                        continue;
                        }

                  if(args[i].equals("-t")) {
                        nextArgIsTestLocation=true;
                        continue;
                        }
                  if(args[i].equals("-o")) {
                        nextArgIsOutputDirectory=true;
                        continue;
                        }
                  if(args[i].equals("-r")) {
                        nextArgIsRunNo=true;
                        continue;
                        }
                  if(args[i].equals("-s")) {
                        nextArgIsScanNo=true;
                        continue;
                        }
		  if(args[i].equals("-d")) {
                        dontOverwrite=true;
                        continue;
                        }
                  matcher = testRequestPattern.matcher(args[i]);
                  if(matcher.matches()) {
                     testRequest = Integer.parseInt(args[i].substring(matcher.start(1),matcher.end(1)));
                     continue;
                     }
// check for 14-digit no.
// assume first serial no, otherwise 2nd serial no
                  matcher = serialNoPattern.matcher(args[i]);
                  if(matcher.matches()) {
                      String thisSerialNo = args[i].substring(matcher.start(1),matcher.end(1));
                      if(!firstSerialNo.equals("")) lastSerialNo=thisSerialNo;
                      else firstSerialNo = thisSerialNo;
                      continue;
                      }
                     System.out.println("Unrecognised argument: "+args[i]);
                     System.exit(0);
                   }

// check validity of arguments
                if(testType==-1 && testRequest==-1) showOptions("You must specify a test type: ");
                if(firstSerialNo.equals("")) showOptions("You must specify a serial number. ");
                if(!lastSerialNo.equals("")) {
                    String firstPart = firstSerialNo.substring(0,9);
                    String lastPart = lastSerialNo.substring(0,9);
                    if(!firstPart.equals(lastPart)) showOptions("Second serial no is not the same devicetype as the first serial no. Try again: ");
		    }
                else lastSerialNo=firstSerialNo;
// Run and Scan
                if(scanNo!=null && runNo!=null) runNo+="-"+scanNo;
                else if(runNo!=null) runNo+="%";

                if(testRequest!=-1 && testType!=-1) {
                   System.err.println("Cant request more than one type of download at the same time.");
                   System.exit(0);
                   }                  
                if(testRequest>SCTDBInfo.SCTDB_TEST_IV) {
                   System.err.println(testRequest+" is not a known test index.");
                   System.exit(0);
                   }
// now download
		String baseSN = firstSerialNo.substring(0,9);
		String firstSN = firstSerialNo.substring(9);
		String lastSN = lastSerialNo.substring(9);
		int i1 = Integer.parseInt(firstSN);
		int i2 = Integer.parseInt(lastSN);
		
		
		long l1 = Long.parseLong(firstSerialNo);
		long l2 = Long.parseLong(lastSerialNo);
		for(long l=l1;l<=l2;l++) {
		    try {
			String sn = Long.toString(l);
			if(testRequest==-1) printRawData(sn, l);
			else doTestRequest(sn, l);
		    }catch(Exception e) {
			System.out.println("Failed to connect to database: "+e.toString());
		    }
		}
	    }
	
	public static java.util.Map getSerialMap() throws Exception {
	    if (serialNoMap == null) serialNoMap = GeneralUtilities.getRawDataLists(firstSerialNo, lastSerialNo, testLocation, testType, temperature, runNo, testRequest);
	    return serialNoMap;
	}
	
	public static void doTestRequest(String sn, long l) throws Exception {
	    String fileName = sn+"_"+SCTDBInfo.sctdaqNormalTestNames[testRequest]+".dat";
	    //Don't do anything more if the file already exists and we've been told not to overwrite
	    if (dontOverwrite && new File(fileName).exists()) return;
	    
	    SCTDBTestInfoHolder testInfo = (SCTDBTestInfoHolder)getSerialMap().get(new Long(l));
	    if(testInfo==null) {
		System.out.println("**No data available for "+sn);
		return;
	    }		
	    String result = GeneralUtilities.getTestString(testRequest,testInfo.get(SCTDBTestInfoHolder.TESTNUMBER));
	    saveFile(fileName,result,testInfo);
	}
	
	public static void showOptions(String text) {
	    System.out.println(text+"\n");
	    System.out.println("**Compulsory** parameters:");
	    System.out.println(" -n to retrieve test results for test index n (see list below)  OR");
	    System.out.println("'-iv' to retrieve iv data files  OR");
	    System.out.println("'-rc' to retieve RC data files  OR");
	    System.out.println("'-xml' to retrieve module configuration XML files  OR");
	    System.out.println("'-trim' to retrieve trim files (mask and trim settings)  OR");
	    System.out.println("'-3ptgain' to retrieve RC data files from 3ptgain tests");
	    System.out.println("- one (or two) 14 digit serial numbers to retrieve data for the");
	    System.out.println("  specified serial number or range of serial numbers\n");
	    System.out.println("**Optional** parameters:");  
	    System.out.println("'-warm' to retrieve only warm data");
	    System.out.println("'-cold' to retrieve only cold data");        
	    System.out.println("'-o outputDirectory' to write data files to outputDirectory");
	    System.out.println("'-t testlocation' to download only data taken at testlocation");
	    System.out.println("'-r RunNumber' to download only data for the given RunNumber");
	    System.out.println("'-s ScanNumber' to download only data for the given ScanNumber (if RunNumber also requested)");
	    System.out.println("\nTest Index vs test type:");
	    for(int i=0;i<12;i++) System.out.println(i+" - "+SCTDBInfo.sctdaqNormalTestNames[i]);
	    System.exit(0);
	}

  private static void saveFile(String fname, String data, SCTDBTestInfoHolder testInfo) {
     try { 
       File output = (outputDirectory!=null) ? new File(outputDirectory,fname) : new File(fname);
       BufferedWriter out = new BufferedWriter(new FileWriter(output));
       out.write(data);
       out.close();
       System.out.println("Saved "+fname+" uploaded by "+testInfo.get(SCTDBTestInfoHolder.LOCATION)+" on "+testInfo.get(SCTDBTestInfoHolder.DATE));
     }catch(Exception e){System.err.println("**ERROR saving file - "+e.toString());}
}



  private static void printRawData(String sn, long l) throws Exception {
      String fname = sn;
      switch(testType) {
      case SCTDBInfo.SCTDB_TEST_IV:
	  fname ="_iv.dat";
	  break;
      case SCTDBInfo.SCTDB_TEST_NPTGAIN:
	  fname+="_rc.dat";
	  break;
      case SCTDBInfo.SCTDB_TEST_TIMEWALK:
	  fname+=".xml";
	  break;
	  
      case SCTDBInfo.SCTDB_TEST_3PTGAIN:
	  fname+="_rc3.dat";
	  break;
      case SCTDBInfo.SCTDB_TEST_TRIM:	//Note this is slightly dodgy - 2 files for trim
	  fname+=".trim";
	  break;
      default:
	  System.out.println("Unrecognized testType: " + testType);
	  return;
      }
      
      //Don't do anything more if the file already exists and we've been told not to overwrite
      if (dontOverwrite && new File(fname).exists()) return;
      
      SCTDBTestInfoHolder testInfo = (SCTDBTestInfoHolder)getSerialMap().get(new Long(l));
      if(testInfo==null) {
	  System.out.println("**No data available for "+sn);
	  return;
      }
      
      Vector theData = GeneralUtilities.getRawData(testInfo.get(SCTDBTestInfoHolder.TESTNUMBER));
      sn =testInfo.get(SCTDBTestInfoHolder.SN);
      if(theData.size()!=2 && theData.size()!=4) {
	  System.err.println("Strange data size for "+sn+" : "+theData.size());
	  return;
      }
      File output;
      BufferedWriter out;
      if(theData.size()==2) {	  
	  saveFile(fname,(String)theData.elementAt(1),testInfo);
      } else if(theData.size()==4 && testType==SCTDBInfo.SCTDB_TEST_TRIM) {
	  fname = sn+".trim";
	  saveFile(fname,(String)theData.elementAt(1),testInfo); 
	  fname = sn+".mask";
	  saveFile(fname,(String)theData.elementAt(3),testInfo);
      }
  }
  
  


}
