package ProdDatabase;
import java.io.*;
import java.util.Vector;
import java.util.Hashtable;

import Preferences.*;

public class SignoffData implements ModuleSignoffData {

   Hashtable data;
   String uploadInfo;

   public SignoffData() {
       data = new Hashtable();
       }

   public SignoffData(String testno) {
       data = new Hashtable();
       try {
         Vector rawData = GeneralUtilities.getRawData(testno);
         if(rawData.size()>0) {
             extractSignoffInfo((String)rawData.elementAt(1));
             if(!data.containsKey(keywords[ModuleSignoffData.SERIALNO])) {
                String sn = GeneralUtilities.getSerialNo(testno);
                if(sn!=null) data.put(keywords[ModuleSignoffData.SERIALNO],sn);
                }
             }
       }catch(Exception e){System.err.println("SignoffData:: Exception downloading signoffInfo: "+e.toString());}
       }

   public SignoffData(String uploadInfo, String dataString) {
       this.uploadInfo = uploadInfo;
       data = new Hashtable();
       extractSignoffInfo(dataString);
       }

   private void extractSignoffInfo(String dataString) {
       String[] lines = dataString.split("[\\n\\r]");
       String keyword="None";
       for(int line=0;line<lines.length;line++) {
           if(lines[line].startsWith("#")) continue;
           if(lines[line].startsWith("%")) {
             keyword=lines[line];
             continue;
             }
           if(data.containsKey(keyword)) {
               String oldData = (String)data.get(keyword);
               oldData += "\n"+lines[line];
               data.put(keyword,oldData);
               }
           else data.put(keyword,lines[line]);
           }
        }


   public String getString(int index) {
       if(!data.containsKey(keywords[index])) return null;
       return (String)data.get(keywords[index]);
       }
   public void put(String key, String value) {
       data.put(key,value);
       }
   public void put(int ikey, String value) {
       put(keywords[ikey],value);
       }
   public String getUploaderInfo() {
       return uploadInfo;
       }
    public Vector allFieldsPresent(int uploadType) {
        Vector listOfMissingFields = new Vector();
        for(int i=0;i<keywords.length;i++) {
           if(compulsoryFields[uploadType][i] && !data.containsKey(keywords[i])) listOfMissingFields.add(descriptions[i]);
           }
        // if barrelcategory is '56', then require a reason
        if(data.containsKey(keywords[BARREL])) {
           if(((String)data.get(keywords[BARREL])).matches("5?6") && !data.containsKey(keywords[B56REASON])) listOfMissingFields.add(descriptions[B56REASON]);
           }
        // if category is 'FAIL' then require a reason
        if(data.containsKey(keywords[CATEGORY])) {
           if(((String)data.get(keywords[CATEGORY])).equals("FAIL") && !data.containsKey(keywords[FAILREASON])) listOfMissingFields.add(descriptions[FAILREASON]);
           }
        return listOfMissingFields;
        }
    public String writeUploadDataFile(String sn) throws Exception {
         long nowtime = java.util.Calendar.getInstance().getTimeInMillis();
         Long tname = new Long(nowtime);
        File outFile = new File(PreferencesInterface.getInstance().getPreference(PreferencesInterface.UPLOAD_DIR),sn+"_"+tname.toString()+".txt");
        BufferedWriter out = new BufferedWriter(new FileWriter(outFile));
        for(int i=0;i<keywords.length;i++) {
            if(!data.containsKey(keywords[i])) continue;
            out.write(keywords[i]);
            out.newLine();
            out.write((String)data.get(keywords[i]));
            out.newLine();
            }
         out.close();
         return outFile.getAbsolutePath();
         }

}