/*
 * ManualConfiguration.java
 *
 * Created on 01 October 2003, 10:56
 */

package DisplayGUI;

/**
 *
 * @author  robinson
 */
public class ManualConfiguration extends javax.swing.JFrame implements displayParams, SCTInfo, java.awt.event.ActionListener {
    boolean menuSetup=true;
    gui guiControl;
    int snCount=3000;
    /** Creates new form ManualConfiguration */
    public ManualConfiguration(gui parent) {
        guiControl=parent;
        initComponents();
    }
    

    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        sctViewList = new javax.swing.JComboBox();
        SCTViewLabel = new javax.swing.JLabel();
        locationList = new javax.swing.JComboBox();
        positionList = new javax.swing.JComboBox();
        ModuleLabel = new javax.swing.JLabel();
        LocationLabel = new javax.swing.JLabel();
        jTextField1 = new javax.swing.JTextField(14);
        PositionLabel = new javax.swing.JLabel();
        AddModuleButton = new javax.swing.JButton();
        QuitButton = new javax.swing.JButton();
        titleLabel = new javax.swing.JLabel();
        MURLabel = new javax.swing.JLabel();
        MURField = new javax.swing.JTextField(10);


        titleLabel.setFont(displayTitleFont);
        titleLabel.setForeground(darkBlueColor);
        ModuleLabel.setFont(displayTextFont);
        PositionLabel.setFont(displayTextFont);
        SCTViewLabel.setFont(displayTextFont);
        LocationLabel.setFont(displayTextFont);
        QuitButton.setFont(displayTextFont);
        AddModuleButton.setFont(displayTextFont);
        sctViewList.setFont(displayTextFont);
        locationList.setFont(displayTextFont);
        positionList.setFont(displayTextFont);
        jTextField1.setFont(displayTextFont);
        MURField.setFont(displayTextFont);
        MURLabel.setFont(displayTextFont);

        sctViewList.setBackground(backgroundColor);
        locationList.setBackground(backgroundColor);
        positionList.setBackground(backgroundColor);

        sctViewList.addActionListener(this);

        getContentPane().setBackground(backgroundColor);
        getContentPane().setLayout(new java.awt.GridBagLayout());

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.12;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(sctViewList, gridBagConstraints);

        SCTViewLabel.setText("SCT Component:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 0.5;
        getContentPane().add(SCTViewLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weighty = 0.15;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(locationList, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weighty = 0.12;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(positionList, gridBagConstraints);

        ModuleLabel.setText("Module SerialNo:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(ModuleLabel, gridBagConstraints);

        LocationLabel.setText("Location:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(LocationLabel, gridBagConstraints);

//        jTextField1.setText("SCTTestAPI_PseudoModule");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weighty = 0.12;
        getContentPane().add(jTextField1, gridBagConstraints);

        PositionLabel.setText("Position:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(PositionLabel, gridBagConstraints);

        MURLabel.setText("MUR:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(MURLabel, gridBagConstraints);

        MURField.setText("0");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weighty = 0.12;
        getContentPane().add(MURField, gridBagConstraints);

        AddModuleButton.setText("Add Module");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(AddModuleButton, gridBagConstraints);
        AddModuleButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                AddModule(evt);
            }
        });


        QuitButton.setText("Close");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(QuitButton, gridBagConstraints);
        QuitButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                QuitForm(evt);
            }
        });


        titleLabel.setText("Manual Configuration");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(titleLabel, gridBagConstraints);

        for(int i=0;i<SCTViewNames.length;i++) sctViewList.addItem(SCTViewNames[i]);
        setBarrelMenuItems(0);

        menuSetup=false;

        setLocationRelativeTo(guiControl);
        pack();
        showFrame();


    }

    public void showFrame() {
        int view = guiControl.displayPane.getSCTView();
        sctViewList.setSelectedIndex(view);
        setVisible(true);
//        show();
        }

    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {
        setVisible(false);
    }

    private void QuitForm(java.awt.event.ActionEvent evt) {
        setVisible(false);
        }

    private void AddModule(java.awt.event.ActionEvent evt) {       
       String sn = jTextField1.getText();
       int mur=0;      


       try {
          mur = Integer.parseInt(MURField.getText());
       }catch(Exception e) {
          javax.swing.JOptionPane.showMessageDialog(null,"Invalid MUR number","Input error",javax.swing.JOptionPane.ERROR_MESSAGE);
          return;
          }
       int position = positionList.getSelectedIndex();
       if(sctViewList.getSelectedIndex()<4) position = Integer.parseInt((String)positionList.getSelectedItem());

       if(sn.equals("SCTTestAPI_PseudoModule") || (sn.length()==14 && sn.startsWith("2022"))) {
             String response;
             if((response=ConfigurationInterface.getInstance().addModule(sctViewList.getSelectedIndex(),locationList.getSelectedIndex(),position,mur,0,sn))==null) {
                 guiControl.displayStatus.setModuleGroupSelectionMode();
                 if(ConfigurationInterface.getInstance().isConfigured()) guiControl.menuBar.enableDisplayMenuItems(true);
                 }
             else javax.swing.JOptionPane.showMessageDialog(null,response,"Configuration Error",javax.swing.JOptionPane.ERROR_MESSAGE);
       }
       else javax.swing.JOptionPane.showMessageDialog(null,"Invalid serial number","Input error",javax.swing.JOptionPane.ERROR_MESSAGE);
       //
        }

    
    
    // Variables declaration - do not modify
    private javax.swing.JButton AddModuleButton;
    private javax.swing.JLabel LocationLabel;
    private javax.swing.JLabel ModuleLabel;
    private javax.swing.JLabel PositionLabel;
    private javax.swing.JButton QuitButton;
    private javax.swing.JButton randomButton;
    private javax.swing.JLabel SCTViewLabel;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JComboBox locationList;
    private javax.swing.JComboBox positionList;
    private javax.swing.JComboBox sctViewList;
    private javax.swing.JLabel titleLabel;
    private javax.swing.JLabel MURLabel;
    private javax.swing.JTextField MURField;
    // End of variables declaration

    /** Change of sctView selection  */
    public void actionPerformed(java.awt.event.ActionEvent e) {
        if(menuSetup || e.getSource()!=sctViewList) return;
        int index = sctViewList.getSelectedIndex();
        if(index<4) setBarrelMenuItems(index);
        else {
            index-=3;
            if(index>=10) index-=9;
            setEndCapMenuItems(index);
            }
        }

    public void setBarrelMenuItems(int index) {
        locationList.removeAllItems();
        for(int i=0;i<barrelRows[index];i++) locationList.addItem("Row "+Integer.toString(i));
        positionList.removeAllItems();
        for(int i=1;i<=6;i++) positionList.addItem(Integer.toString(i));
        for(int i=-1;i>=-6;i--) positionList.addItem(Integer.toString(i));
        }
    public void setEndCapMenuItems(int index) {
        locationList.removeAllItems();
        locationList.addItem("Quadrant TR");
        locationList.addItem("Quadrant BR");
        locationList.addItem("Quadrant BL");
        locationList.addItem("Quadrant TL");
        positionList.removeAllItems();
        for(int i=1;i<=13;i++) positionList.addItem("O"+Integer.toString(i));
        if(index!=9) for(int i=1;i<=10;i++) positionList.addItem("M"+Integer.toString(i));
        switch(index) {
           case 2:
           case 3:
           case 4:
           case 5:
           case 6:
             for(int i=1;i<=10;i++) positionList.addItem("I"+Integer.toString(i));
           default:
           }
         }



 
        
    
}
