/*
 * runStatus.java
 *
 * Created on 27 June 2003, 16:47
 */

package DisplayGUI;

/**
 *
 * @author  robinson
 */
public class DisplayStatus {
    
    public static final int UNDEFINED = 0;
    public static final int CONFIGURED = 1;
    public static final int MODULE_GROUP_SELECTION = 1;
    public static final int IS_MONITOR = 2;
    public static final int TEST_DATA = 3;
    public static final int SCTDB_DATA = 4;
    public static final int SCTDB_RODDAQ_DATA=5;
    public static final int DCS_DATA = 6;
    public static final int IV_DATA=7;

    public static final String[] statusNames = {"DISPLAY UNCONFIGURED","ModuleGroup Selection","Data Manager","Test Results","SCTDAQ Reference","SctRodDaq Reference","DCS Info","IVscan Data"};

    public int status;
    public int configuredStatus;
    gui guiControl;
    
    /** Creates a new instance of runStatus */
    public DisplayStatus(gui parent) {
        guiControl=parent;
        status = UNDEFINED;
        configuredStatus=UNDEFINED;
    }
    public void setStatus(int status) {
        this.status=status;
    }
    public int getStatus() {
        return status;
    }

    public void setConfigurationMode() {

// by default, everything in module group 0 to start with
          ConfigurationInterface conf = ConfigurationInterface.getInstance();
          conf.getConfiguration(0);
          if(conf.isConfigured()) {
            guiControl.displayPane.refreshDisplay();
            configuredStatus=CONFIGURED;
            setModuleGroupSelectionMode();
            guiControl.menuBar.enableDisplayMenuItems(true);
            }         
          }

    public void setModuleGroupSelectionMode() {
        unsubscribeAll();
        status=MODULE_GROUP_SELECTION;
        boolean displayWriteAccess=true; 
//        guiControl.displayPane.setWriteAccess(displayWriteAccess);
        showParameterSelector();
        guiControl.colorScalePane.setColorScale();
        guiControl.tablesDisplayPane.updateTables();
//        System.out.println("DisplayStatus:: setDisplayColors");
        guiControl.displayPane.setDisplayColors();
        guiControl.displayPane.refreshDisplay();
        guiControl.menuBar.updateMenuStates();
    }
    public void setISMode() {
        unsubscribeAll();
        status = IS_MONITOR;
        showParameterSelector();
        guiControl.colorScalePane.setColorScale();
//        guiControl.isInterface.setServerName(0);  // set Event Data to start with
        guiControl.isInterface.subscribe();
//        guiControl.tablesDisplayPane.updateTables();
        guiControl.menuBar.updateMenuStates();
//        guiControl.displayPane.setDisplayColors();
//        guiControl.displayPane.refreshDisplay();
    }
    public void setTestDataMode(int testDataType) {
        if(status==TEST_DATA && testDataType==guiControl.isInterface.getListFilterIndex()) return;
        unsubscribeAll();
        int oldStatus=status;
        status = TEST_DATA;
        showParameterSelector();
        guiControl.displayPane.resetDisplayOption();
        guiControl.colorScalePane.setColorScale();
        guiControl.isInterface.subscribe(testDataType);
        if(testDataType==-1) guiControl.menuBar.resetTestListFilter(); // set test filter to 'All tests'
        guiControl.menuBar.updateMenuStates();
    }
    public void setSCTDBDataMode(int testDataType) {
        if(status==SCTDB_DATA && testDataType==guiControl.isInterface.getListFilterIndex()) return;
        unsubscribeAll();
        int oldStatus=status;
        status = SCTDB_DATA;
        showParameterSelector();
        guiControl.colorScalePane.setColorScale();
        guiControl.isInterface.subscribe(testDataType);
        if(testDataType==-1) guiControl.menuBar.resetTestListFilter(); // set test filter to 'All tests'
        guiControl.menuBar.updateMenuStates();
    }
    public void setSCTDBRodDaqMode(int testDataType) {
        if(status==SCTDB_RODDAQ_DATA && testDataType==guiControl.isInterface.getListFilterIndex()) return;
        unsubscribeAll();
        int oldStatus=status;
        status = SCTDB_RODDAQ_DATA;
        showParameterSelector();
        guiControl.colorScalePane.setColorScale();
        guiControl.isInterface.subscribe(testDataType);
        if(testDataType==-1) guiControl.menuBar.resetTestListFilter(); // set test filter to 'All tests'
        guiControl.menuBar.updateMenuStates();
    }
    public void setDCSDataMode() {
        unsubscribeAll();
        int oldStatus=status;
        status = DCS_DATA;
        showParameterSelector();
        guiControl.colorScalePane.setColorScale();
        guiControl.isInterface.subscribe();
        guiControl.menuBar.updateMenuStates();
    }
    public void setIVDataMode() {
        unsubscribeAll();
        int oldStatus=status;
        status = IV_DATA;
        showParameterSelector();
        guiControl.colorScalePane.setColorScale();
        guiControl.isInterface.subscribe();
        guiControl.menuBar.updateMenuStates();

// if not IV scans already present, prompt the user to import some!
        IVTestSelection iv = guiControl.tablesDisplayPane.getIVTestSelection();
        if(iv==null) new IVScanLister(guiControl.displayPane.getSCTView()).show();
    }

    public void unsubscribeAll() {
        guiControl.isInterface.unsubscribe();
        }
    private void showParameterSelector() {
        guiControl.selectorPane.initParamList();
        }
}
