/*
 * ColorScaleChooser.java
 */
package DisplayGUI;

import java.awt.Color;
import java.util.Vector;
import java.util.List;
import java.util.ArrayList;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableModel;
import javax.swing.event.*;
import java.util.*;

public class ColorScaleChooser extends javax.swing.JFrame implements displayParams,ListSelectionListener {

    private javax.swing.JTable table;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JCheckBox isGradientPaint,isLogScale,isPersisted;
    private javax.swing.JLabel title;
    private javax.swing.JScrollPane scrollPane;
    private javax.swing.JButton defaultButton, applyButton, closeButton;
    private javax.swing.JMenuItem removeItem, addItem;
    private javax.swing.JMenu dataPopupMenu;

    ColorScale thisColorScale;
    MyTableModel tableModel = new MyTableModel();
    ListSelectionModel rowSM;
    ColorScaleManager csm = ColorScaleManager.getInstance();
    boolean editValues;

    gui guiControl;

    public ColorScaleChooser(gui parent, ColorScale colorScale) {
        super("Edit Colour Scale");
        guiControl=parent;
        thisColorScale = new ColorScale(colorScale);
	int status = guiControl.displayStatus.getStatus();

        editValues = (status==DisplayStatus.TEST_DATA || status==DisplayStatus.SCTDB_DATA || status==DisplayStatus.DCS_DATA || status==DisplayStatus.SCTDB_RODDAQ_DATA);
        if(editValues && status!=DisplayStatus.DCS_DATA) editValues = (guiControl.selectorPane.getDisplayParameterIndex()>0);
        if(editValues && status==DisplayStatus.TEST_DATA) editValues = (guiControl.selectorPane.getDisplayParameterIndex()<=4); // Token and RToken comments
        initComponents();
        fillTable();
        getTableEditorMenu();
        table.addMouseListener(new tableMouseAdapter());
        removeItem.setEnabled(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });
        addItem.setEnabled(editValues);
    }

    private void initComponents() {

        getContentPane().setBackground(backgroundColor);

        table = new javax.swing.JTable(tableModel);
//        table.setPreferredScrollableViewportSize(new Dimension(300, 70));

        //Create the scroll pane and add the table to it.
        scrollPane = new javax.swing.JScrollPane(table);

        //Set up renderer and editor for the Favorite Color column.

        table.setDefaultRenderer(Color.class,new ColorRenderer(true));

        table.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        rowSM = table.getSelectionModel();
        rowSM.addListSelectionListener(this);

        java.awt.GridBagConstraints gridBagConstraints;

//        buttonGroup1 = new javax.swing.ButtonGroup();
        title = new javax.swing.JLabel();
        isGradientPaint = new javax.swing.JCheckBox();
        isLogScale = new javax.swing.JCheckBox();
        isPersisted = new javax.swing.JCheckBox();

        applyButton = new javax.swing.JButton();
        defaultButton = new javax.swing.JButton();
        closeButton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        title.setFont(displayBoldFont);
        title.setForeground(darkBlueColor);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.weighty = 0.1;
        getContentPane().add(title, gridBagConstraints);


        scrollPane.setBackground(new java.awt.Color(255, 255, 255));
        table.setBackground(new java.awt.Color(255, 255, 255));
        scrollPane.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));
        scrollPane.setMaximumSize(new java.awt.Dimension(500, 500));
        scrollPane.setMinimumSize(new java.awt.Dimension(50, 50));
        scrollPane.setPreferredSize(new java.awt.Dimension(240, 200));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 3, 3);
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 0.8;
        getContentPane().add(scrollPane, gridBagConstraints);

        isGradientPaint.setText("Gradient Scale");
        isGradientPaint.setFont(displayScaleFont);
        isGradientPaint.setEnabled(editValues);
        isGradientPaint.setBackground(backgroundColor);
        isGradientPaint.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                thisColorScale.setGradientPaint(isGradientPaint.isSelected());
                if(!isGradientPaint.isSelected()) {
                    isLogScale.setSelected(false);
                    thisColorScale.setLogScale(isLogScale.isSelected());
                   isLogScale.setEnabled(false);
                    }
                 else isLogScale.setEnabled(true);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(isGradientPaint, gridBagConstraints);

        isLogScale.setSelected(true);
        isLogScale.setText("Log Scale");
        isLogScale.setFont(displayScaleFont);
        isLogScale.setEnabled(editValues);
        isLogScale.setBackground(backgroundColor);
        isLogScale.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
              thisColorScale.setLogScale(isLogScale.isSelected());
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.CENTER;
        getContentPane().add(isLogScale, gridBagConstraints);

        isPersisted.setSelected(true);
        isPersisted.setText("Persist changes");
        isPersisted.setFont(displayScaleFont);
        isPersisted.setBackground(backgroundColor);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(isPersisted, gridBagConstraints);

        applyButton.setText("Apply");
        applyButton.setFont(displayScaleFont);
        applyButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                  if(thisColorScale.getNoPoints()<2) {
                     javax.swing.JOptionPane.showMessageDialog(null,"There must be at least 2 points in the scale","Invalid Color Scale",javax.swing.JOptionPane.WARNING_MESSAGE);
                     return;
                   }                      
                  csm.updateScale(new ColorScale(thisColorScale), isPersisted.isSelected());
                  guiControl.colorScalePane.setColorScale();
                  guiControl.displayPane.setDisplayColors();
                  guiControl.displayPane.refreshDisplay();
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        getContentPane().add(applyButton, gridBagConstraints);

        defaultButton.setText("Default");
        defaultButton.setFont(displayScaleFont);
        defaultButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                  thisColorScale = new ColorScale(csm.getDefaultColorScale(thisColorScale.getTitle()));
                  fillTable();
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
       gridBagConstraints.weightx = 0.3;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.CENTER;
        getContentPane().add(defaultButton, gridBagConstraints);

        closeButton.setText("Close");
        closeButton.setFont(displayScaleFont);
        closeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeDialog(null);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
       gridBagConstraints.weightx = 0.4;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(closeButton, gridBagConstraints);


        pack();
    }

private void fillTable() {

     tableModel.reTable();

     isGradientPaint.setSelected(thisColorScale.isGradientPaint());
     isLogScale.setSelected(thisColorScale.isLogScale());
     title.setText("Edit: "+thisColorScale.getTitle());

     }

public void showNewScale(ColorScale colorScale) {
     thisColorScale=new ColorScale(colorScale);
     editValues = (guiControl.displayStatus.getStatus()==DisplayStatus.TEST_DATA || guiControl.displayStatus.getStatus()==DisplayStatus.SCTDB_DATA);
     if(editValues) editValues = (guiControl.selectorPane.getDisplayParameterIndex()>0);
     removeItem.setEnabled(false);
     addItem.setEnabled(editValues);
     isLogScale.setEnabled(editValues);
     isGradientPaint.setEnabled(editValues);
     fillTable();
     }

    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
    }

public class MyTableModel extends javax.swing.table.AbstractTableModel {
    private String[] columnNames = {"Data","Label","Color"};

    public MyTableModel() {
         }


    public void reTable() {
         fireTableChanged(null); // Tell the listeners a new table has arrived.
         return ;
    }



    //  Now the Implementation of the TableModel Interface
   
    public String getColumnName(int column) {
        if (columnNames[column] != null) {
            return columnNames[column];
        } else {
            return "";
        }
    }

    public Class getColumnClass(int column) {
            return getValueAt(0, column).getClass();

   }

    public boolean isCellEditable(int row, int column) {
            return false; 
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public int getRowCount() {
        return thisColorScale.getNoPoints();
    }

    public Object getValueAt(int row, int column) {

        ColorScalePoint scalePoint = thisColorScale.getColorScalePoint(row);
        return scalePoint.getData(column);
    }


    public void setValueAt(Object value, int row, int column) {
        ColorScalePoint scalePoint = thisColorScale.getColorScalePoint(row);
        scalePoint.setData(column,value); 
    }



}

    class tableMouseAdapter extends java.awt.event.MouseAdapter {
            public void mouseClicked(java.awt.event.MouseEvent e) {
               int rowSelect = table.rowAtPoint(new java.awt.Point(e.getX(),e.getY()));
               rowSM.setSelectionInterval(rowSelect,rowSelect); 
               switch(e.getModifiers()) {
                 case java.awt.event.InputEvent.BUTTON1_MASK: 
                       ScalePointEditor spe = new ScalePointEditor(ColorScaleChooser.this,true,thisColorScale.getColorScalePoint(rowSelect),editValues);
                       ColorScalePoint newPoint = spe.getColorScalePoint();
                       if(newPoint!=null) {
                          thisColorScale.setColorScalePoint(rowSelect,newPoint);
                          fillTable();
                          }
                       break;
                 case java.awt.event.InputEvent.BUTTON2_MASK:
                 case java.awt.event.InputEvent.BUTTON3_MASK:
                       javax.swing.JPopupMenu pMenu = dataPopupMenu.getPopupMenu();
                       pMenu.show(e.getComponent(),e.getX(),e.getY());
                       pMenu.setInvoker(dataPopupMenu); 
                       break;
                 default:
                 }
            }
    }

   private void getTableEditorMenu() {
       dataPopupMenu = new javax.swing.JMenu("Table Editor");
       dataPopupMenu.setFont(menuFont);

       removeItem = new javax.swing.JMenuItem("Remove point");
       removeItem.setFont(menuFont);
       dataPopupMenu.add(removeItem);
       removeItem.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
               thisColorScale.removePoint(rowSM.getMinSelectionIndex());
               fillTable();
                     }
          });  
       addItem = new javax.swing.JMenuItem("Add new point...");
       addItem.setFont(menuFont);
       dataPopupMenu.add(addItem);
       addItem.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                    ScalePointEditor spe = new ScalePointEditor(ColorScaleChooser.this,true,null,editValues);
                    ColorScalePoint newPoint = spe.getColorScalePoint();
                    if(newPoint!=null) {
                          thisColorScale.add(newPoint);
                          fillTable();
                          }
                     }

          });  

       }

    public void valueChanged(ListSelectionEvent e) {


              if (e.getValueIsAdjusting()) return;

              ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        
              if (lsm.isSelectionEmpty()) {
                 //no rows are selected
                   removeItem.setEnabled(false);
                   return;
                   }

              removeItem.setEnabled(editValues);
          }



}
