#include "configserver.h"
#include <pmg/pmg_initSync.h>

using namespace std;

using namespace SctConfiguration;

void pmgSynch(void *) {
    pmg_initSync();
}

int main(int argc, char** argv) 
{
  IPCCore::init(false);   // No multithreads
  IPCPartition p("SCT");
  IPCServer* server = new IPCServer(sctConf_C_Configuration_serverName, p);

  MRSStream mrsStream("SCT");

  ConfigServer *h;
  try {
    h = new ConfigServer(sctConf_C_Configuration_instanceName, server);
  } catch(ConfigurationException &c) {
    mrsStream << "CONF_FAILED " << MRS_FATAL << MRS_QUALIF("sctConf") 
              << MRS_TEXT((string("Failed to create Configuration Service") + c.what()).c_str()) << ENDM;
    return 1;
  }

  if (!h->publish()) {
    mrsStream << "CONF_FAILED " << MRS_FATAL << MRS_QUALIF("sctConf") 
              << MRS_TEXT("Failed to publish Configuration Service") << ENDM;

    cout << "Failed to publish Configuration" << endl;
    return 2;
  } 
  cout << "Configuration server published, awaiting commands\n";
  try {
    server->doSoon(pmgSynch, NULL);
    server->run();
  } catch(ConfigurationException &c) {
    mrsStream << "CONF_FAILED " << MRS_FATAL << MRS_QUALIF("sctConf") 
              << MRS_TEXT((string("Failed to run Configuration Service") + c.what()).c_str()) << ENDM;
    cout << "Configuration run threw exception " << c.what() << endl;
    return 3;
  }

  cout << "Run over" << endl;

  h->withdraw();
  delete h;
  delete server;
}

