#include <stdlib.h>
#include <ipc/object.h>
#include <ipc/server.h>
#include <boost/lexical_cast.hpp>

#include "Sct/SctNames.h"

#include "sctConf.hh"
#include "configArchiveServer.h"
#include "configserver.h"

using namespace SctConfiguration;
using namespace Sct;
using namespace boost;

typedef sctConf_T_ilu__prefix_idlExceptionType_ConfigurationException ConfException;

static void myRaise(sctConfStatus *_status, const ConfigurationException &c);

using namespace std;

IPCServer* ipcServer;

ConfigArchiveServer::ConfigArchiveServer(const char* oid, IPCServer* server) : IPCObject(oid, server) 
{
}

ConfigArchiveServer::~ConfigArchiveServer() 
{
}

sctConf_T_Configuration * ConfigArchiveServer::getOldRunConfiguration (sctConfStatus *_status, ilu_Cardinal runNumber, ilu_Boolean start)
{
  string fileName = SctNames::getPersistentDir() + "/configArchive_" + lexical_cast<string>(runNumber) + (start ? "_start" : "_end") + ".xml.gz";    
  
  ConfigServer *oldConfig = new ConfigServer(fileName.c_str(), ipcServer);
  configs.push_back(oldConfig);

  myRaise(_status, ConfigurationException("Archive not found!"));

  return IPCObjectVar<ConfigServer>::duplicate(oldConfig);
}

sctConf_T_RunNumberList ConfigArchiveServer::listConfigurationRuns (sctConfStatus *_status) 
{
  //@todo Needs c++ izing...

  string command = "ls -1 " + SctNames::getPersistentDir() + "/configArchive_*_start.*";
  FILE *lsInput = popen(command.c_str(), "r");

  sctConf_T_RunNumberList result;
  result = _sctConf_T_RunNumberList_sequence::Create(4, NULL);
  result->Clear(0);

  while(!feof(lsInput)) {
    char *file = new char[512];

    file = fgets(file, 512, lsInput);

    if(file) {
      int runNumber = 0;

      string format = SctNames::getPersistentDir() + "/configArchive_%d_start";
      sscanf(file, format.c_str(), &runNumber);

      result->Append(runNumber);
    }
  }

  return result;
}

int main(int argc, char** argv) 
{
  IPCCore::init(false);   // No multithreads
  IPCPartition p("SCT");
  ipcServer = new IPCServer(sctConf_C_ConfigurationArchive_instanceName, p);

  ConfigArchiveServer *h = new ConfigArchiveServer(sctConf_C_ConfigurationArchive_serverName, ipcServer);
  if (!h->publish()) {
    cout << "Failed to publish Configuration Archive" << endl;
    return 0;
  } 
  cout << "Configuration Archiving server published:\n";
  
//   sctConfStatus status;
//   h->listConfigurationRuns(&status);
  cout << "\n ... awaiting commands\n";

  try {
    ipcServer->run();
  } catch(ConfigurationException &c) {
    cout << "Configuration run threw exception " << c.what() << endl;
  }

  cout << "Configuration Archive Server run over" << endl;

  h->withdraw();
  delete h;
  delete ipcServer;
}

void myRaise(sctConfStatus *_status, const ConfigurationException &c) 
{
  ConfException *e = new ConfException;
  char *buffer = new char[strlen(c.what())+1];

  cout << "Raising exception " << c.what() << endl;

  strcpy(buffer, c.what());
  buffer[strlen(c.what())] = 0;
  e->detail = buffer;
  sctConf_G::RaiseException(_status, sctConf_E_ConfigurationException, e);
}
