#include <stdio.h>
#include "CommonWithDsp/registerIndices.h"

#define func(name) printf(" {0x%x,\t\"%s\"},\n", name, #name)

int main() {
  printf("struct regIds { int id; char *name; };\n");
  printf("struct regIds regNames[] = {\n");
  func(RRIF_CODE_VERSION);
  func(RRIF_CMND_0);
  func(RRIF_CMND_1);
  func(RRIF_STATUS_0);
  func(RRIF_STATUS_1);
  func(FE_CMND_MASK_0_LO);
  func(FE_CMND_MASK_0_HI);
  func(FE_CMND_MASK_1_LO);
  func(FE_CMND_MASK_1_HI);
  for(int fmt=0; fmt<8; fmt++) {
    for(int link=0; link<12; link++) {
      func(FMT_LINK_OCC_CNT(fmt, link));
    }
  }
  printf("   // End of registers\n");
  printf(" {-1,\t\"\"}\n};\n");

  return 0;
}

