/*
 * ISHistogram3DAdapter.java
 *
 * Created on 28 November 2002, 11:01
 */

package oh.aida;
import hep.aida.*;
import oh.*;

/**
 *
 * @author  palmer
 */
public class ISHistogram3DAdapter extends ISHistogramAdapter implements IHistogram3D {
    
    /** Creates a new instance of ISHistogram3DAdapter */
    public ISHistogram3DAdapter(ISHistogram3D data) {
        super(data);
    }
    
    public void add(hep.aida.IHistogram3D iHistogram3D) throws java.lang.IllegalArgumentException {
        unimplementedFunction();
    }
    
    public int binEntries(int param, int param1, int param2) throws java.lang.IllegalArgumentException {
        return 0;
    }
    
    public int binEntriesX(int param) throws java.lang.IllegalArgumentException {
        return 0;
    }
    
    public int binEntriesY(int param) throws java.lang.IllegalArgumentException {
        return 0;
    }
    
    public int binEntriesZ(int param) throws java.lang.IllegalArgumentException {
        return 0;
    }
    
    public double binError(int param, int param1, int param2) throws java.lang.IllegalArgumentException {
        return _binError(index(param, param1, param2));
    }
    
    public double binHeight(int param, int param1, int param2) throws java.lang.IllegalArgumentException {
        return _binHeight(index(param, param1, param2));
    }
    
    public double binHeightX(int param) throws java.lang.IllegalArgumentException {
        unimplementedFunction();
        return 0;
    }
    
    public double binHeightY(int param) throws java.lang.IllegalArgumentException {
        unimplementedFunction();
        return 0;
    }
    
    public double binHeightZ(int param) throws java.lang.IllegalArgumentException {
        unimplementedFunction();
        return 0;
    }
    
    public double binMeanX(int param, int param1, int param2) throws java.lang.IllegalArgumentException {
        unimplementedFunction();
        return 0;
    }
    
    public double binMeanY(int param, int param1, int param2) throws java.lang.IllegalArgumentException {
        unimplementedFunction();
        return 0;
    }
    
    public double binMeanZ(int param, int param1, int param2) throws java.lang.IllegalArgumentException {
        unimplementedFunction();
        return 0;
    }
    
    public int coordToIndexX(double param) {
        unimplementedFunction();
        return 0;
    }
    
    public int coordToIndexY(double param) {
        unimplementedFunction();
        return 0;
    }
    
    public int coordToIndexZ(double param) {
        unimplementedFunction();
        return 0;
    }
    
    public void fill(double param, double param1, double param2) throws java.lang.IllegalArgumentException {
        unimplementedFunction();
    }
    
    public void fill(double param, double param1, double param2, double param3) throws java.lang.IllegalArgumentException {
        unimplementedFunction();
    }
    
    public double meanX() {
        return ((ISHistogram3D)data).is_xmean;
    }
    
    public double meanY() {
        return ((ISHistogram3D)data).is_ymean;
    }
    
    public double meanZ() {
        return ((ISHistogram3D)data).is_zmean;
    }
    
    public double rmsX() {
        return ((ISHistogram3D)data).is_xrms;
    }
    
    public double rmsY() {
        return ((ISHistogram3D)data).is_yrms;
    }
    
    public double rmsZ() {
        return ((ISHistogram3D)data).is_zrms;
    }
    
    public hep.aida.IAxis xAxis() {
        return new AxisAdapter(0);
    }
    
    public hep.aida.IAxis yAxis() {
        return new AxisAdapter(1);
    }
    
    public hep.aida.IAxis zAxis() {
        return new AxisAdapter(2);
    }
    
    
    /**
     * Helpful functions
     */
    protected int index(int indexX, int indexY, int indexZ )  {
        int bcx = xAxis().bins();
        int bcy = yAxis().bins();
        int bcz = zAxis().bins();
        if ( indexX == IAxis.OVERFLOW_BIN ) indexX = bcx + 1;
        else if ( indexX == IAxis.UNDERFLOW_BIN ) indexX = 0;
        else indexX++;
        if ( indexY == IAxis.OVERFLOW_BIN ) indexY = bcy + 1;
        else if ( indexY == IAxis.UNDERFLOW_BIN ) indexY = 0;
        else indexY++;
        if ( indexZ == IAxis.OVERFLOW_BIN ) indexZ = bcy + 1;
        else if ( indexZ == IAxis.UNDERFLOW_BIN ) indexZ = 0;
        else indexZ++;

        return indexX + ( bcx + 2 ) * (indexY + (bcy+2) * indexZ);
     }
}
