#include "ArchivingManager.h"
#include "Sct/SctNames.h"

#include "Sct/IoExceptions.h"
#include "Sct/LogicErrors.h"
#include <sstream>
#include <iomanip>
#include <cstdlib>
#include <boost/date_time/posix_time/posix_time.hpp>

using namespace Sct;
using namespace boost;



	using boost::shared_ptr;

	ArchivingManager::ArchivingManager() {}

	ArchivingManager::~ArchivingManager() {}

	ArchivingManager& ArchivingManager::instance() throw () {
	    static ArchivingManager bertha;
	    return bertha;
	}

	
	
	shared_ptr<ArchScanResult> ArchivingManager::getScanFromMap(shared_ptr<const Serializable> ob) const throw(Sct::LogicError) {
	  const string classname = ob->getClassName();
	    ArchivingScanMap::const_iterator it = theScanMap.find(classname);
	    if ( it == theScanMap.end() ){
		cerr << "ArchivingScanManager::getFromScanMap no archiver for " << classname << endl;
		cerr << "known Scanarchivers:" << endl ;
		for (ArchivingScanMap::const_iterator it = theScanMap.begin(); it != theScanMap.end(); ++it){
		    cerr << (*it).first << endl;
		}
		throw InvalidArgumentError( string("ArchivingManager::getScanFromMap no Scanarchiver for ") + classname, __FILE__, __LINE__ );
	    } else {
	      
	      return (*it).second ;
	      
	    }
	}

       shared_ptr<ArchTestResult> ArchivingManager::getTestFromMap(shared_ptr<const Serializable> ob) const throw(Sct::LogicError) {
	 const string classname = ob->getClassName();
	 ArchivingTestMap::const_iterator it = theTestMap.find(classname);
	 if ( it == theTestMap.end() ){
	   cerr << "ArchivingTestManager::getFromMap no archiver for " << classname << endl;
	   cerr << "known Testarchivers:" << endl ;
	   for (ArchivingTestMap::const_iterator it = theTestMap.begin(); it != theTestMap.end(); ++it){
	     cerr << (*it).first << endl;
	   }
	   throw InvalidArgumentError( string("ArchivingManager::getTestFromMap no Testarchiver for ") + classname, __FILE__, __LINE__ );
	 } else {
	   return (*it).second;
	   
	 }
       }

	bool ArchivingManager::addScanArchiver(const string& scanName, shared_ptr<ArchScanResult> archiver) throw(Sct::LogicError) {
	    if (theScanMap.find(scanName) == theScanMap.end() ){
		theScanMap[scanName] = archiver;
		return true;
	    }
	    return false;
	}

        bool ArchivingManager::addTestArchiver(const string& testName, shared_ptr<ArchTestResult> archiver) throw(Sct::LogicError) {
	    if (theTestMap.find(testName) == theTestMap.end() ){
		theTestMap[testName] = archiver;
		return true;
	    }
	    return false;
	}
