#include "ArchTrimRangeTestResult.h"
#include "ArchivingManager.h"
#include <is/isinfo.h>
#include <iostream>
#include <vector>
#include "SctData/Stat.h"
#include "Sct/SctParameters.h"
#include <TFile.h>
#include <TDirectory.h>
#include <TObject.h>
#include <TVector.h>
#include <TVectorD.h>
#include "SummaryWriter/SummaryWriter.h"
#include "SummaryWriter/SummaryManager.h"


using namespace SctData;

bool ArchTrimRangeTestResult::inMap = ArchivingManager::instance().addTestArchiver("SctData::TrimRangeTestResult", shared_ptr<ArchTestResult>(new ArchTrimRangeTestResult()));  

/***********************  Constructor  *************** */

ArchTrimRangeTestResult::ArchTrimRangeTestResult(): ArchTestResult()  {

  //cout<< "I am in the ArchTrimRangeTestResult Default Constructor"<< endl;
  
  
  
}
  
  
ArchTrimRangeTestResult::ArchTrimRangeTestResult(shared_ptr<TrimRangeTestResult> trimtest): ArchTestResult(trimtest)  {

  //cout<< "I am in the ArchTrimRangeTestResult Constructor"<< endl;
  
  /*--- Initialisation ---*/
  TGraph* g = new TGraph();
  TF1* f = new TF1("tf1","pol1");
  for (unsigned int ichip = 0; ichip < nChipModule; ++ichip) {
    for (unsigned ichannel=0; ichannel<nChannelChip; ++ichannel){
      Stat<TrimRangeTestResult::TrimData> trim = trimtest->chipTrimData[ichip]->channelData.getAt(ichannel);
      //TGraph* g = new TGraph();
      //TF1* f = new TF1("tf1","pol1");
      g->SetMarkerColor(ichannel);
      f->SetLineColor(ichannel);
      g->Set(trim.value.graph.size());
      for (unsigned ipt=0; ipt<trim.value.graph.size(); ++ipt){
	g->SetPoint(ipt,trim.value.graph[ipt].first, trim.value.graph[ipt].second);
      }
      f->SetParameters(trim.value.p0,trim.value.p1);
      
      chipTrim.push_back(g);
      chipTrimFit.push_back(f);
      
      
    }
    
    
  }


  //Retrieve Test Summary from IS
  try{
    TestSummary(trimtest);
  } catch(...) {
    cout<<" ERROR in retrieving Test Summary from IS" <<endl;
  }

}







/**********************  Other Member Functions  *********************/

ArchTrimRangeTestResult::~ArchTrimRangeTestResult()  {
  
  //cout << "I am in the ArchTrimRangeTestResult destructor" << endl;
  

  
}



void ArchTrimRangeTestResult::SaveTrimRangeTestDataOnly() {


  cout<<"Saving TrimRangeTestData "<<endl;
     
  //TO DO : Save time and date of first and last saving  
  
  string filename = names->getfilename();
  string moduleID = names->getModuleID(); 
  string testType  = names->getTestType(); 
  string runID = names->getRunID();
  //string chipTrimID = names->getChipTrimID();
  //string chipTrimFitID = names->getChipTrimFitID();


  /* OPENING TEST FILE  */
  //cout << "Opening file..."<<endl; 
 

  TFile *storage_file = new TFile(filename.c_str(),"update");
  //storage_file->ls();
  //cout << "The file .root succesfully open"<<endl; 

  


  /* CREATING DIRECTORIES and SAVING DATA  */
  
    
    /* Making RunNumber   */
    //cout<<"I am making RunNumber Dir"<<endl;
    //storage_file->GetListOfKeys()->Print();
    TDirectory *this_run = (TDirectory*) gDirectory->Get(runID.c_str());
    //cout<<"The RUN is "<< runID <<endl;
    
    if (!this_run) {
      //cout<<"This NEW run "<< runID <<" doesn't exist"<<endl;
      this_run = storage_file->mkdir(runID.c_str());
      //cout<<"New RunNumber Dir made "<<endl;
    }
    storage_file->GetListOfKeys()->Print();
    this_run->cd();  //make this_run the current directory
    
   
    /* Saving RunNumber as a TVector: it is saved only once, just the first time   */
    TObject* pers_runnumber = gDirectory->FindObjectAny(runID.c_str()); 
    if (!pers_runnumber) {
      double frunNumber = runNumber;
      TVector run(1,1,frunNumber, "END");
      run.Write(runID.c_str());
    }
    
    
    /* Making moduleNumber   */
    
    TDirectory* this_module = (TDirectory*) gDirectory->Get(moduleID.c_str()); 
    //cout<<"The MODULE is "<< moduleID <<endl;
    if (!this_module) {
      //cout<<"This NEW module "<< moduleID <<" doesn't exist"<<endl;
      this_module =gDirectory ->mkdir(moduleID.c_str());
    }
    
    
    /* Making TestType   */
    //cout<<"I am making TestType Dir "<<endl;
    this_module->cd();  //make this_module the current directory 
    TDirectory* this_testType = (TDirectory*) gDirectory->Get(testType.c_str());
    //cout<<"The test Type is "<< testType <<endl;
    
    if (!this_testType) {
      //cout<<"This NEW test "<< testType <<" doesn't exist"<<endl;
      this_testType = gDirectory->mkdir(testType.c_str());
    }
    this_testType->cd();


    /* Saving chipTrim */
    int chipN = 0;
   
    for (vector<TGraph*>::iterator i = chipTrim.begin(); i!=chipTrim.end(); i++) {
      (*i)->Write(names->getChipTrimID(chipN).c_str());
      chipN++;
    }   
   


    /* Saving chipTrimFit */
    chipN = 0;
    for (vector<TF1*>::iterator i = chipTrimFit.begin(); i!=chipTrimFit.end(); i++) {
      (*i)->Write(names->getChipTrimFitID(chipN).c_str());
      chipN++;
    }   
    
    
    //Save TestSummery (if it has been retrieved)
    if(testSummary != NULL) {
      //cout<<"testSummary != NULL...";
      TObject* pers_testSummary = gDirectory->FindObjectAny(names->getTestSummaryID().c_str());
      if (!pers_testSummary) {
	testSummary->Write(names->getTestSummaryID().c_str());
	//cout<<"testSummary SAVED"<<endl;
      }
    }
 
    
    /* CLOSING FILE  */
    //cout << "I am Closing File " << endl;
    storage_file->Close();
    delete storage_file;
    //cout << "File closed " << endl;




}



void ArchTrimRangeTestResult::Save() {

  //cout << "I am in SaveTrimRange() " <<endl;
  ArchTestResult::Save();
  SaveTrimRangeTestDataOnly();
  //SaveRawScans();
  //SaveFitScans();
  AddTestToIndex();
  


}


void ArchTrimRangeTestResult::TestSummary(shared_ptr<TrimRangeTestResult> trimtest) {
  
  ostringstream datastream;
  shared_ptr<const SctData::TestSummary::SummaryWriter> writer = 
    SctData::TestSummary::SummaryManager::instance().getWriter(trimtest->getClassName());
  writer->writeHeader(*(trimtest.get()), datastream);
  writer->write(*(trimtest.get()), datastream);
  string myString = datastream.str();
  //cout<< "TestSummary = " << myString;

  testSummary = new TObjString(myString.c_str());

  


  return;


}



