#include "ArchTimeWalkTestResult.h"
#include "ArchivingManager.h"
#include <TFile.h>
#include <TKey.h>
#include <TDirectory.h>
#include <TSystem.h>
#include <TNamed.h>
#include <TObject.h>
#include <TObjArray.h>
#include <TString.h>
#include <TObjString.h>
#include <TVector.h>
#include <TVectorD.h>
#include <TH1.h>
#include <TH2.h>
#include <TCanvas.h>
#include <TROOT.h>
#include <is/isinfo.h>
#include <iostream>
#include <vector>
#include <boost/shared_ptr.hpp>
#include "SummaryWriter/SummaryWriter.h"
#include "SummaryWriter/SummaryManager.h"


bool ArchTimeWalkTestResult::inMap = ArchivingManager::instance().addTestArchiver("SctData::TimeWalkTestResult", shared_ptr<ArchTestResult>(new ArchTimeWalkTestResult()));  

/***********************  Constructor  *************** */

ArchTimeWalkTestResult::ArchTimeWalkTestResult(): ArchTestResult()  {

  //cout<< "I am in the ArchTimeWalkTestResult Default Constructor"<< endl;
  
  
  
}


ArchTimeWalkTestResult::ArchTimeWalkTestResult(shared_ptr<TimeWalkTestResult> TWtest): ArchTestResult(TWtest)  {

  //cout<< "I am in the ArchTimeWalkTestResult Constructor"<< endl;
  
  /*--- Initialisation ---*/

  for (unsigned int i = 0; i<12;i++) { 
    //*----status_direct:
    timewalk.push_back(TWtest->getChipResult(i).timewalk);
    shared_ptr<TVector> tmp_v_timewalk (new TVector(1,1,TWtest->getChipResult(i).timewalk,"END"));
    v_timewalk.push_back(tmp_v_timewalk);


    //*----calibration:
    calibration.push_back(TWtest->getChipResult(i).calibration);
    shared_ptr<TVector> tmp_v_calibration (new TVector(1,1,TWtest->getChipResult(i).calibration,"END"));
    v_calibration.push_back(tmp_v_calibration);


  }


     



  //Retrieve Test Summary from IS
  try{
    TestSummary(TWtest);
  } catch(...) {
    cout<<" ERROR in retrieving Test Summary from IS" <<endl;
  }



}



/**********************  Other Member Functions  *********************/


ArchTimeWalkTestResult::~ArchTimeWalkTestResult()  {
  
  //cout << "I am in the ArchTimeWalkTestResult destructor" << endl;
  

  
}



void ArchTimeWalkTestResult::SaveTimeWalkTestDataOnly() {

  cout<<"Saving TimeWalkTestData "<<endl;
  //TO DO : Save time and date of first and last saving  

  string filename = names->getfilename();
  string moduleID = names->getModuleID(); 
  string testType  = names->getTestType(); 
  string runID = names->getRunID();
  string timewalkID = names->getTimewalkID();
  string calibrationID = names->getCalibrationID();
 

  
  /* OPENING TEST FILE  */
  cout << "Opening file..."<<endl; 
 
  TFile *storage_file = new TFile(filename.c_str(),"update");
  //storage_file->ls();
  //cout << "The file .root succesfully open"<<endl; 

  


  /* CREATING DIRECTORIES and SAVING DATA  */
  
    
    /* Making RunNumber   */
    //cout<<"I am making RunNumber Dir"<<endl;
    //storage_file->GetListOfKeys()->Print();
    TDirectory *this_run = (TDirectory*) gDirectory->Get(runID.c_str());
    //cout<<"The RUN is "<< runID <<endl;
    
    if (!this_run) {
      //cout<<"This NEW run "<< runID <<" doesn't exist"<<endl;
      this_run = storage_file->mkdir(runID.c_str());
      //cout<<"New RunNumber Dir made "<<endl;
    }
    storage_file->GetListOfKeys()->Print();
    this_run->cd();  //make this_run the current directory
    
   
    /* Saving RunNumber as a TVector: it is saved only once, just the first time   */
    TObject* pers_runnumber = gDirectory->FindObjectAny(runID.c_str()); 
    if (!pers_runnumber) {
      double frunNumber = runNumber;
      TVector run(1,1,frunNumber, "END");
      run.Write(runID.c_str());
    }
    
    
    /* Making moduleNumber   */
    
    TDirectory* this_module = (TDirectory*) gDirectory->Get(moduleID.c_str()); //Can be made using FindAnyObject
    //cout<<"The MODULE is "<< moduleID <<endl;
    if (!this_module) {
      //cout<<"This NEW module "<< moduleID <<" doesn't exist"<<endl;
      this_module =gDirectory ->mkdir(moduleID.c_str());
    }
    
    
    /* Making TestType   */
    //cout<<"I am making TestType Dir "<<endl;
    this_module->cd();  //make this_module the current directory 
    TDirectory* this_testType = (TDirectory*) gDirectory->Get(testType.c_str());
    //cout<<"The test Type is "<< testType <<endl;
    
    if (!this_testType) {
      //cout<<"This NEW test "<< testType <<" doesn't exist"<<endl;
      this_testType = gDirectory->mkdir(testType.c_str());
    }
    this_testType->cd();


    
    
    /* Saving timewalk as a TVector */
    //cout << "I am Saving  as  TVectorD's" << endl;
    //TObject* pers_timewalk = gDirectory->FindObjectAny(timewalkID.c_str()); 
    TDirectory* pers_timewalk = (TDirectory*) gDirectory->Get(timewalkID.c_str());
    if (!pers_timewalk) {
      //cout << "The timewalk never saved before...saving now"<<endl;
      pers_timewalk = this_testType->mkdir(timewalkID.c_str());
      
    }
    pers_timewalk->cd();

    int chipN=0;
    for (vector<shared_ptr<TVector> >::iterator i = v_timewalk.begin(); i!=v_timewalk.end(); i++) {
      (*i)->Write(names->getTimewalkID(chipN).c_str());
      ++chipN;
    } 
    this_testType->cd();


    /* Saving calibration  as a TVector */
    //cout << "I am Saving calibration as  TVectorD's" << endl;
    //TObject* pers_calibration = gDirectory->FindObjectAny(calibrationID.c_str()); 
     TDirectory* pers_calibration = (TDirectory*) gDirectory->Get(calibrationID.c_str());
    if (!pers_calibration) {
      //cout << "The calibration never saved before...saving now"<<endl;
      pers_calibration = this_testType->mkdir(calibrationID.c_str());
    }
    pers_calibration->cd();

    chipN=0;
    for (vector<shared_ptr<TVector> >::iterator i = v_timewalk.begin(); i!=v_timewalk.end(); i++) {
      (*i)->Write(names->getCalibrationID(chipN).c_str());
      ++chipN;
    } 
    this_testType->cd();
    


    //Save TestSummery (if it has been retrieved)
    if(testSummary != NULL) {
      //cout<<"testSummary != NULL...";
      TObject* pers_testSummary = gDirectory->FindObjectAny(names->getTestSummaryID().c_str());
      if (!pers_testSummary) {
	testSummary->Write(names->getTestSummaryID().c_str());
	//cout<<"testSummary SAVED"<<endl;
      }
    }
   




    /* CLOSING FILE  */
    //cout << "I am Closing File " << endl;
    storage_file->Close();
    delete storage_file;
    //cout << "File closed " << endl;




}





void ArchTimeWalkTestResult::Save() {

  ArchTestResult::Save();
  SaveTimeWalkTestDataOnly();
  //SaveRawScans();
  //SaveFitScans();
  AddTestToIndex();

}



void ArchTimeWalkTestResult::TestSummary(shared_ptr<TimeWalkTestResult> TWtest) {
  
  ostringstream datastream;
  shared_ptr<const SctData::TestSummary::SummaryWriter> writer = 
    SctData::TestSummary::SummaryManager::instance().getWriter(TWtest->getClassName());
  writer->writeHeader(*(TWtest.get()), datastream);
  writer->write(*(TWtest.get()), datastream);
  string myString = datastream.str();
  //cout<< "TestSummary = " << myString;

  testSummary = new TObjString(myString.c_str());

  


  return;


}

