#include "ArchTestNames.h"
#include <iostream>
#include <stdlib.h>
#include <string>

using std::string;

/********************************** ArchScan Methods Definitions ************************/


/***********************  Constructor  *************** */

ArchTestNames::ArchTestNames()  {

  runID ="Run?";
  moduleID ="Module?";
  testType ="Stand-AloneScans";
  
}
  
  
ArchTestNames::ArchTestNames(const long runNumber, const string Pers_moduleName,const string tType )  {
  
  char tmp_runID[40];
  sprintf(tmp_runID,"Run%i",runNumber);
  runID = tmp_runID ;

  int dot = Pers_moduleName.find('.');
  moduleID = "Module" + Pers_moduleName.substr(0, dot) ;

  int size = tType.size();
  int first_colon = tType.find(':');
  string tmp_testType = tType.substr(first_colon+1, size);
  int second_colon = tmp_testType.find(':');
  size = tmp_testType.size();
  tmp_testType = tmp_testType.substr(second_colon+1, size);
  string tag("Result");
  int start = tmp_testType.find(tag);
  //cout <<"start = "<<start<<endl;
  testType = tmp_testType.substr(0, start);
  //cout <<" TestType = " << testType<<endl;

}


void ArchTestNames::setModuleName(string moduleName)  {
    
  int dot = moduleName.find('.');
  moduleID = "Module" + moduleName.substr(0, dot) ;
  
  
}


void ArchTestNames::setTestType(string tType) {
  int size = tType.size();
  int first_colon = tType.find(':');
  string tmp_testType = tType.substr(first_colon+1, size);
  int second_colon = tmp_testType.find(':');
  size = tmp_testType.size();
  tmp_testType = tmp_testType.substr(second_colon+1, size);
  string tag("Result");
  int start = tmp_testType.find(tag);
  //cout <<"start = "<<start<<endl;
  testType = tmp_testType.substr(0, start);
  //cout <<" TestType = " << testType<<endl;
  

}

const string ArchTestNames::getDefectID(unsigned int firstChannel, unsigned int NChannels) {

  string DefectName;
  char tmp_DefectName[40];
  sprintf(tmp_DefectName,"Defects_First%i_%i",firstChannel,NChannels);
  DefectName= tmp_DefectName;
  return DefectName;

}

const string ArchTestNames::getfilename() {

  string filename;
  //filename = runID + "." + testID + ".root";
  filename = runID + ".root";
  return filename;

}

const string ArchTestNames::getIndexFileName() {

  string index;
  index = "ArchIndex";
  index = index + ".out";
  return index;

}

const string ArchTestNames::getChipTrimID(int chipN) {

  string ChipTrimID;
  char tmp_ChipTrimID[40];
  sprintf(tmp_ChipTrimID,"Trim_Chip%i",chipN);
  ChipTrimID = tmp_ChipTrimID;
  return ChipTrimID;

}


const string ArchTestNames::getChipTrimFitID(int chipN) {

  string ChipTrimFitID;
  char tmp_ChipTrimFitID[40];
  sprintf(tmp_ChipTrimFitID,"TrimFit_Chip%i",chipN);
  ChipTrimFitID = tmp_ChipTrimFitID;
  return ChipTrimFitID;

}


const string ArchTestNames::getFBChipN(unsigned int chipN) {

  string ChipN;
  char tmp_ChipN[40];
  sprintf(tmp_ChipN,"FullBypas_Chip%i",chipN);
  ChipN= tmp_ChipN;
  return ChipN;

}

const string ArchTestNames::getChipFitID(unsigned int chipN) {

  string ChipN;
  char tmp_ChipN[40];
  sprintf(tmp_ChipN,"ChipFit%i",chipN);
  ChipN= tmp_ChipN;
  return ChipN;

}

const string ArchTestNames::getChipGraphID(unsigned int chipN) {

  string ChipN;
  char tmp_ChipN[40];
  sprintf(tmp_ChipN,"ChipGraph%i",chipN);
  ChipN= tmp_ChipN;
  return ChipN;

}

const string ArchTestNames::getChannelFitID(unsigned int channelN) {

  string ChannelN;
  char tmp_ChannelN[40];
  sprintf(tmp_ChannelN,"ChannelFit%i",channelN);
  ChannelN= tmp_ChannelN;
  return ChannelN;

}

const string ArchTestNames::getChannelGraphID(unsigned int channelN) {

  string ChannelN;
  char tmp_ChannelN[40];
  sprintf(tmp_ChannelN,"ChannelGraph%i",channelN);
  ChannelN= tmp_ChannelN;
  return ChannelN;

}

const string ArchTestNames::getChipNOFitID(unsigned int chipN) {

  string ChipN;
  char tmp_ChipN[40];
  sprintf(tmp_ChipN,"ChipNOFit%i",chipN);
  ChipN= tmp_ChipN;
  return ChipN;

}

const string ArchTestNames::getChipNOGraphID(unsigned int chipN) {

  string ChipN;
  char tmp_ChipN[40];
  sprintf(tmp_ChipN,"ChipNOGraph%i",chipN);
  ChipN= tmp_ChipN;
  return ChipN;

}


const string ArchTestNames::getTimewalkID(unsigned int chipN) {

  string ChipN;
  char tmp_ChipN[40];
  sprintf(tmp_ChipN,"TimeWalk%i",chipN);
  ChipN= tmp_ChipN;
  return ChipN;

}


const string ArchTestNames::getCalibrationID(unsigned int chipN) {

  string ChipN;
  char tmp_ChipN[40];
  sprintf(tmp_ChipN,"Calibration%i",chipN);
  ChipN= tmp_ChipN;
  return ChipN;

}
